/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9f5j
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
    /**
     * ワンダフルでソースコードが長くなるのを防ぐために別のところに
     * 素材を保存しておく方法
     * これを使う時点で長いとか言わないでー＞＜
     * これで、長いソースのせいでコンパイラの
     * レスポンス遅くなる心配も軽減のはず！ｗ
     * 
     * 2009-3-14 選んだファイルを Base64 エンコードする
     * http://wonderfl.kayac.com/code/7759319c71a3b018008d108bfd08425cd72a5c77
     * を改造して、
     * http://wonderfl.kayac.com/code/0ee7133d97f027ae357545c2aaba8e252436933e
     * を作った、 ↑をフォークして、 
     * DataBase Class のデータを書き換える。
     * あとは WonderflLoader を使ってこれを
     * Asset として読み込む。
     * 
     * 例として タイマーを作ってみた。
     * Click でスタート、 再度 Click でストップ、
     * 再度クリックでリセットしてスタート。
     * カップラーメンタイマーにでも使ってください。
     * 
     * @author jc at bk-zen.com
     */
    public class LoadTest extends Sprite
    {
        private const phaseLoad: String = "Now Loading...\n";
        private const phaseInit: String = "Now Initializing...\n";
        private var txt: TextField;
        private var time: int;
        private var disp: BitmapData;
        private var rectangle: Rectangle = new Rectangle(0, 0, 28, 42);
        private var clearRect: Rectangle = new Rectangle(0, 0, 308, 42);
        private var point: Point = new Point();
        private var startTime: uint = 0;
        private var txtTip: BitmapData;
        private var tf:TextFormat;
        private var phase: String = phaseLoad;
        private var wloader:WonderLoader;
        
        public function LoadTest() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            wloader = new WonderLoader();
            wloader.addEventListener(WonderLoader.EVENT_LOADED, onLoaded);
            wloader.addEventListener(WonderLoader.EVENT_INIT, onInit);
            wloader.addEventListener(WonderLoader.EVENT_COMP, onComp);
            wloader.addEventListener(ProgressEvent.PROGRESS, onProgress);
            wloader.load("http://wonderfl.kayac.com/code/0ee7133d97f027ae357545c2aaba8e252436933e");
            // ↑ または ↓ でロードできる。
            //wloader.load("0ee7133d97f027ae357545c2aaba8e252436933e");
            txt = new TextField();
            txt.text = phase + "0%";
            txt.autoSize = TextFieldAutoSize.LEFT;
            tf = txt.getTextFormat();
            tf.align = TextFormatAlign.CENTER;
            tf.size = 20;
            txt.setTextFormat(tf);
            txt.x = (stage.stageWidth - txt.width) >> 1;
            txt.y = (stage.stageHeight - txt.height) >> 1;
            addChild(txt);
        }
        
        private function onComp(e:Event):void 
        {
            removeChild(txt);
            txtTip = Bitmap(wloader.getAssetFile("data1")).bitmapData;
            disp = new BitmapData(224, 42, true, 0x0);
            var bmp: Bitmap = new Bitmap(disp);
            bmp.x = (stage.stageWidth - bmp.width) / 2;
            bmp.y = (stage.stageHeight - bmp.height) / 2;
            addChild(bmp);
            //
            stage.addEventListener(MouseEvent.CLICK, onClick);
            loop(0);
        }
        
        
        private function onProgress(e:ProgressEvent):void 
        {
            var p: int = e.bytesLoaded / e.bytesTotal * 100;
            txt.text = phase + p + "%";
            txt.setTextFormat(tf);
            txt.x = (stage.stageWidth - txt.width) >> 1;
            txt.y = (stage.stageHeight - txt.height) >> 1;
        }
        
        private function onInit(e: Event): void { }
        
        private function onLoaded(e: Event): void 
        { 
            phase = phaseInit; 
            txt.text = phase + 0 + "%";
            txt.setTextFormat(tf);
            txt.x = (stage.stageWidth - txt.width) >> 1;
            txt.y = (stage.stageHeight - txt.height) >> 1;
        }
        
        private function onClick(e: MouseEvent): void 
        {
            if (startTime == 0)
            {
                startTime = getTimer() / 10;
                addEventListener(Event.ENTER_FRAME, onEnter);
            }
            else 
            {
                startTime = 0;
                removeEventListener(Event.ENTER_FRAME, onEnter);
            }
        }
        
        private function onEnter(e: Event): void 
        {
            time = getTimer() / 10;
            var c: uint = time - startTime;
            loop(c);
        }
        
        private function loop(c: uint): void
        {
            disp.lock();
            disp.fillRect(clearRect, 0x0);
            for (var i:int = 0; i < 8; i++) 
            {
                point.x = 196 - i * 28;
                if (i % 3 == 2)
                {
                    rectangle.x = 10 * 28;
                }
                else if (i == 4)
                {
                    rectangle.x = (c % 6) * 28;
                    c /= 6;
                }
                else
                {
                    rectangle.x = (c % 10) * 28;
                    c /= 10;
                }
                disp.copyPixels(txtTip, rectangle, point);
            }
            disp.unlock();
        }
        
    }
    
}

import flash.display.DisplayObject;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.ProgressEvent;
import flash.system.LoaderContext;
import flash.display.Loader;
import flash.net.URLRequest;

class WonderLoader extends EventDispatcher
{
    private const baseURL: String = "http://wonderfl-swf.kayac.com/swf/usercode/";
    private var content: DisplayObject;
    private var loader: Loader;
    public static const EVENT_LOADED: String = "wl_loaded";
    public static const EVENT_INIT: String = "wl_init";
    public static const EVENT_COMP: String = "wl_comp";
    
    public function WonderLoader()
    {
        super();
    }
    public function load(urlOrId: String, context: LoaderContext = null): void
    {
        var i: int = urlOrId.lastIndexOf("/");
        var id: String = urlOrId.substr(i + 1);
        var urlReq: URLRequest = new URLRequest(baseURL + id.substr(0, 1) + "/" + id.substr(0, 2) + "/" + id.substr(0, 4) + "/" + id + ".swf?t=" + new Date().time);
        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
        loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
        loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgress);
        loader.load(urlReq, context);
    }
    
    private function onProgress(e:ProgressEvent):void { dispatchEvent(e.clone()); }
    
    private function onIOError(e: IOErrorEvent): void { dispatchEvent(e.clone()); }
    
    private function onComp(e: Event): void
    {
        e.target.removeEventListener(Event.COMPLETE, onComp);
        content = loader.content;
        loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onComp);
        loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
        loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, onProgress);
        loader.unload();
        loader = null;
        dispatchEvent(new Event(EVENT_LOADED));
        if (asset.hasOwnProperty("setup")) 
        {
            content.addEventListener(ProgressEvent.PROGRESS, onProgress);
            dispatchEvent(new Event(EVENT_INIT));
            content.addEventListener(EVENT_COMP, onSetup);
            asset.setup();
        }
    }
    
    private function onSetup(e:Event):void 
    {
        dispatchEvent(new Event(EVENT_COMP));
    }
    
    public function getAssetFile(name: String): * { return asset.getAssetFile(name); }
    
    public function get asset(): Object { return Object(content); }
    
}