/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9dyK
 */

/*
 * 誤りが産んだ軌跡
 */
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    [SWF(backgroundColor=0x33ccff)]
    public class Main extends Sprite {
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        private const SC:Point = new Point(SW/2, SH/2);
        
        public var speed:Number = 5;
        public var mpX:Number = 2.0;
        public var mpY:Number = 2.5;
        public var space:Sprite;
        public var mySp:Sprite;
        public var myPos:Sprite;
        
        public function Main():void {
            var sp:Shape = new Shape();
            sp.graphics.beginFill(0);
            sp.graphics.drawRect(0,0,SW,SH);
            sp.graphics.endFill();
            
            space = new Sprite();
            addChild(space);
            space.x = SC.x;
            space.y = SC.y;
            space.z = 0;
            
            myPos = new Sprite();
            myPos.x = 0;
            myPos.y = 0;
            myPos.z = 0;
            
            space.addEventListener(Event.ENTER_FRAME, xFly);
        }
        public function xFly(e:Event):void {
            var toPos:Sprite = new Sprite();
            space.addChild(toPos);
            toPos.graphics.lineStyle(0,0xffffff);
            toPos.graphics.drawCircle(-50,0,10);
            if (space.numChildren > 714) {
                space.removeChildAt(0);
            }
        
            toPos.rotationY = myPos.rotationY + mpY;
            toPos.rotationX = myPos.rotationX + mpX;
            
            var rY:Number = toPos.rotationY/180*Math.PI;
            toPos.x = myPos.x + Math.sin(rY)*speed;
            toPos.z = myPos.z + Math.cos(rY)*speed;
            
            var rX:Number = toPos.rotationX/180*Math.PI;
            toPos.y = myPos.y + Math.sin(rX)*speed;
            toPos.x += Math.cos(rX)*speed;
            
            myPos.rotationX = toPos.rotationX;
            myPos.rotationY = toPos.rotationY;
            myPos.x = toPos.x;
            myPos.y = toPos.y;
            myPos.z = toPos.z;
            
            space.x = -myPos.x + SC.x;
            space.y = -myPos.y + SC.y;
            space.z = -myPos.z;
        }
    }
}