/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9dZS
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import mx.utils.*;
    // @see http://projecteuler.net/index.php?section=problems&id=203
    public class Euler203 extends Sprite {
        private var _tf : TextField;
  
        public function Euler203() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private const N : int = 50;
        
        private function solve() : Number
        {
            var factors : Array = [{}];
            for(var i : int = 1;i <= N;i++){
                factors.push(factor(i));
            }
            
            var summap : Object = {1 : 1};
            for(var n : int = 1;n <= N;n++){
                var prod : Number = 1;
                var map : Object = {};
                for(var k : int = 1;k <= n / 2;k++){
                    prod = prod * (n - k + 1) / k;
                    merge(map, factors[n - k + 1]);
                    sub(map, factors[k]);
                    if(isSquareFree(map)){
                        summap[prod] = 1;
                    }
                }
            }
            
            var sum : Number = 0;
            for(var key : String in summap){
                sum += Number(key);
            }
            
            return sum;
        }
        
        private function merge(a : Object, b : Object) : Object
        {
            for(var key : String in b){
                if(a[key]){
                    a[key] += b[key];
                }else{
                    a[key] = b[key];
                }
            }
            return a;
        }
        
        private function sub(a : Object, b : Object) : Object
        {
            for(var key : String in b){
                if(a[key]){
                    a[key] -= b[key];
                }
            }
            return a;
        }
        
        /*
        private function prod(a : Object) : int
        {
            var ret : int = 1;
            for(var key : String in a){
                ret *= Math.pow(int(key), a[key]);
            }
            return ret;
        }
        */
        
        private function isSquareFree(a : Object) : Boolean
        {
            for each(var val : int in a){
                if(val >= 2)return false;
            }
            return true;
        }
        
        private function factor(n : int) : Object
        {
            var ret : Object = {};
            var sq : int = Math.sqrt(n);
            for(var i : int = 2;i <= sq;i++){
                for(var j : int = 0;n % i == 0;n/=i, j++);
                if(j > 0){
                    ret[i] = j;
                    sq = Math.sqrt(n);
                }
            }
            if(n != 1){
                ret[n] = 1;
            }
            
            return ret;
        }
    }
}