/**
 * Copyright yoneken ( http://wonderfl.net/user/yoneken )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9dZN
 */

// forked from yoneken's Neural Oscillator
// 神経振動子
// 妙な動きに需要はありますか？

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        private static const ELEMENTS_NUM:uint = 8;
        [ArrayElementType("Sprite")] private var a:Array;

        // このあたりの定数をいじると色々複雑な挙動が現れるんだけど，
        // 制御がタイヘン
        private static const B:Number =  8.0;
        private static const W:Number =  8.0;
        private static const u0:Number = 60.0;
        private static const Tu:Number = 20.0;
        private static const Tv:Number = 30.0;

        [ArrayElementType("Number")] private var u:Array;
        [ArrayElementType("Number")] private var du:Array;
        [ArrayElementType("Number")] private var v:Array;
        [ArrayElementType("Number")] private var dv:Array;
        [ArrayElementType("Number")] private var pos:Array;

        public function Main() {
            a = new Array(ELEMENTS_NUM);
            u = new Array(-0.4,-0.2);
            v = new Array( 0.2, 0.1);
            du = new Array(0.0,0.0);
            dv = new Array(0.0,0.0);
            pos = new Array(100.0,100.0);

            for(var i:uint=0;i<ELEMENTS_NUM;i++){
                a[i] = new Sprite();
                a[i].graphics.beginFill(0xffff00);
                a[i].graphics.drawCircle(0,0,10);
                addChild(a[i]);
            }
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, onclicked);
        }

        private function loop(e:Event):void{
            calc();
            for(var i:uint=0;i<ELEMENTS_NUM-1;i++){
                a[i].x = a[i+1].x;
                a[i].y = a[i+1].y;
            }
            pos[0] += dv[0];
            pos[1] += dv[1];
            // du -> dv にしてみても，面白い挙動が得られます

            a[ELEMENTS_NUM-1].x = pos[0];
            a[ELEMENTS_NUM-1].y = pos[1];
        }

        private function onclicked(e:MouseEvent):void{
            pos[0] = e.localX;
            pos[1] = e.localY;
        }
        
        private function calc():void{
            [ArrayElementType("Number")] var y:Array;
            y  = new Array(u[0]>0 ? u[0] : 0, u[1]>0 ? u[1] : 0);
            du[0] = -u[0] -B*v[0] -W*y[1] + u0;
            du[1] = -u[1] -B*v[1] -W*y[0] + u0;
            dv[0] = -v[0] + y[0];
            dv[1] = -v[1] + y[1];
            u[0] += du[0]/Tu;
            u[1] += du[1]/Tu;
            v[0] += dv[0]/Tv;
            v[1] += dv[1]/Tv;
        }
    }
}