/**
 * Copyright Caiim. ( http://wonderfl.net/user/Caiim. )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9dPe
 */

package {
    
    /*
    *    @author Kevin Frando
    */
    
    import flash.text.TextFormatAlign;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.utils.Proxy;
    import flash.events.KeyboardEvent;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.Graphics;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(width='500', height='700', frameRate="25")]
    public class FlashTest extends Sprite {
        
        //enemy
        private var enemyList:Vector.<Enemy> = new Vector.<Enemy>();
        private var enemySpawnDelay:int = 1500;
        private var enemySpawnTimer:Timer = new Timer(enemySpawnDelay);
        private var isSpawningEnemy:Boolean = false;
        private var enemyTextFormat:TextFormat = new TextFormat(null, 20, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
        
        // sprites
        private var mainMenu:Sprite = new Sprite();
        private var gameWorld:Sprite = new Sprite();
            private var gameBGContainer:Sprite = new Sprite();
            private var enemyContainer:Sprite = new Sprite();
            private var playerContainer:Sprite = new Sprite();
                private var reloadBar:Sprite = new Sprite();
            private var bulletContainer:Sprite = new Sprite();
        private var bg:Sprite = new Sprite();
        
        private var playerSprite:Sprite = new Sprite();
        private var newPlayerPos:int = stage.stageWidth/2;
        private var player:PlayerGun = new PlayerGun(10);
        
        //Bullet
        private var bulletList:Vector.<Bullet> = new Vector.<Bullet>();
        private var bulletTextFormat:TextFormat = new TextFormat(null, 15, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
        private var isShooting:String = "";
        
        //explosion
        private var explosionList:Vector.<Explosion> = new Vector.<Explosion>();
        private var explosionContainer:Sprite = new Sprite();
        
        //UI
        private var infoTxt:TextField = new TextField();
        private var infoTextFormat:TextFormat = new TextFormat(null, 20, 0xffffff, true);
        
        //game over
        private var gameOverTxt:TextField = new TextField();
        private var backToMenuTxt:TextField = new TextField();
        
        //main menu
        private var titleTxt:TextField =  new TextField();
        private var guideTxt:TextField =  new TextField();
        
        
        private var score:int = 0;
        private var lives:int = 10;
        
        public function FlashTest() {
            // write as3 code here..
            initDisplay();
            initListener();
        }
        
        private function initDisplay():void
        {
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            addChild(bg);
            
            gameBGContainer.graphics.beginFill(0xdddddd);
            gameBGContainer.graphics.lineStyle(1, 0x999999);
            gameBGContainer.graphics.drawRect(0, stage.stageHeight - 100, stage.stageWidth, 100);
            gameWorld.addChild(gameBGContainer);
            
            playerSprite.graphics.beginFill(0xffffff);
            playerSprite.graphics.lineStyle(1);
            playerSprite.graphics.drawRect(-10, -40, 20, 40);
            playerSprite.graphics.endFill();
            playerSprite.graphics.beginFill(0xffffff);
            playerSprite.graphics.drawCircle(0, 0, 20);
            playerSprite.y = stage.stageHeight - 30;
            playerSprite.x = stage.stageWidth / 2;
            playerContainer.addChild(playerSprite);
            player.setSprite(playerSprite);
            
            playerContainer.addChild(reloadBar);
            
            gameWorld.addChild(enemyContainer);
            gameWorld.addChild(bulletContainer);
            gameWorld.addChild(playerContainer);
            
            infoTxt.defaultTextFormat = infoTextFormat;
            infoTxt.selectable = false;
            infoTxt.width = 500;
            gameWorld.addChild(infoTxt);
            
            gameOverTxt.text = "GAME OVER";
            gameOverTxt.setTextFormat(new TextFormat(null, 50, 0xff0000, true, null, null, null, null, TextFormatAlign.CENTER));
            gameOverTxt.y = 200;
            gameOverTxt.width = stage.stageWidth;
            gameOverTxt.selectable = gameOverTxt.visible = false;
            gameWorld.addChild(gameOverTxt);
            
            backToMenuTxt.text = "(click anywhere to return to menu)";
            backToMenuTxt.setTextFormat(enemyTextFormat);
            backToMenuTxt.selectable = backToMenuTxt.visible = false;
            backToMenuTxt.width = stage.stageWidth;
            backToMenuTxt.y = 300;
            gameWorld.addChild(backToMenuTxt);
            
            addChild(gameWorld);
            
            addChild(explosionContainer);
            
            titleTxt = new TextField();
            titleTxt.text = "Letter Defence";
            titleTxt.setTextFormat(new TextFormat(null, 70, 0x00ff00, true, null, null, null, null, TextFormatAlign.CENTER));;
            titleTxt.width = stage.stageWidth;
            titleTxt.y = 150;
            titleTxt.selectable = false;
            mainMenu.addChild(titleTxt);
            
            guideTxt = new TextField();
            guideTxt.text = "Mouse - move cannon\n\nKeyboard[a-z] - fire cannon\n\nEnemy can only destroyed with the correct letter\n\n\n(click anywhere to start)";
            guideTxt.setTextFormat(enemyTextFormat);
            guideTxt.width = stage.stageWidth;
            guideTxt.height = guideTxt.y = 280;
            guideTxt.selectable = false;
            mainMenu.addChild(guideTxt);
            addChild(mainMenu);
            
        }
        
        private function initListener():void
        {
            stage.addEventListener(MouseEvent.CLICK, startGame);
        }
        
        private function startGame(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.CLICK, startGame);
            mainMenu.visible = false;
            initGame();
        }

        
        private function enemySpawnTick(e:TimerEvent):void
        {
            isSpawningEnemy = true;
            enemySpawnTimer.delay = enemySpawnDelay - (500 * (Math.min(5000, score) / 5000));
        }
        
        private function initGame():void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseBind);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyboardBind);
            enemySpawnTimer.addEventListener(TimerEvent.TIMER, enemySpawnTick);
            addEventListener(Event.ENTER_FRAME, updateGame);
            enemySpawnTimer.start();
        }
        
        private function mouseBind(e:MouseEvent):void
        {
            var tmpX:int = e.stageX;
            if(tmpX < 50) 
                tmpX = 50;
            else if( tmpX > stage.stageWidth - 50) 
                tmpX = stage.stageWidth - 50;
            newPlayerPos = tmpX;
        }
        
        private function keyboardBind(e:KeyboardEvent):void
        {
           if(!player.reloading && e.keyCode >= Keyboard.A && e.keyCode <= Keyboard.Z)
           {
                isShooting = String.fromCharCode(e.keyCode);
                player.fire();
           }
        }

        private function updateGame(e:Event):void
        {
            for each(var en:Enemy in enemyList)
            {
                en.update();
                if(en.sprite.y + en.sprite.height > stage.stageHeight - 100)
                {
                    en.kill();
                    enemyList.splice(enemyList.indexOf(en), 1);
                    explosionList.push(new Explosion(en.sprite.x+en.sprite.width/2, en.sprite.y+en.sprite.height/2));
                    lives--;
                    if(lives <= 0)
                    {
                        endGame();
                    }

                }

            }
            
            for each(var b:Bullet in bulletList)
            {
                b.update();
                if(b.sprite.y < 30)
                {
                    b.kill();
                    bulletList.splice(bulletList.indexOf(b), 1);
                    continue;
                }    
                for each(en in enemyList)
                {
                    if(b.sprite.hitTestObject(en.sprite))
                    {
                        if(en.letter == b.letter)
                        {
                            en.kill();
                            b.kill();
                        }
                        else
                            b.kill();
                        
                        if(b.isDead)
                        {
                            bulletList.splice(bulletList.indexOf(b), 1);
                            explosionList.push(new Explosion(b.sprite.x+b.sprite.width/2, b.sprite.y+b.sprite.height/2));
                            if(en.isDead)
                            {
                                enemyList.splice(enemyList.indexOf(en), 1);
                                explosionList.push(new Explosion(en.sprite.x+en.sprite.width/2, en.sprite.y+en.sprite.height/2));
                                score+=100;
                            }
                        }
                    }
                }
            }
            
            explosionContainer.graphics.clear();
            
            for each(var ex:Explosion in explosionList)
            {
                ex.update();
                explosionContainer.graphics.beginFill(0xff0000, 1 * ex.life / Explosion.MAX_LIFE);
                for each(var sp:Spark in ex.sparks)
                    explosionContainer.graphics.drawRect(sp.pos.x, sp.pos.y, 4, 4);
                if(ex.isDead)
                    explosionList.splice(explosionList.indexOf(ex), 1);
            }
            
           player.move(newPlayerPos);
           player.update();
           reloadBar.graphics.clear();
           reloadBar.graphics.beginFill(0x00ee00);
           reloadBar.graphics.drawRect(player.sprite.x + 30, player.sprite.y, 5, player.reloadScale() * -30);
            
           if(isShooting != "")
               shoot();
            
            if(isSpawningEnemy)
            {
                spawnEnemy();
            }
            
            score++;
            infoTxt.text = "Lives  : " + lives + "\nScore : " + score;
        }
        
        private function shoot():void
        {
            var bulletSprite:Sprite = createBullet(isShooting);
            var p:Point = player.getPos();
            bulletSprite.x = p.x-10;
            bulletSprite.y = p.y;
            
            
            
            var b:Bullet = new Bullet(bulletSprite, isShooting, 5);
            bulletList.push(b);
            
            bulletContainer.addChild(bulletSprite);
            
            isShooting = "";
        }
        
        private function createBullet(letter:String):Sprite
        {
            var sprite:Sprite = new Sprite();
            var t:TextField = new TextField();
            t.selectable = false;
            t.width = t.height = 20;
            t.background = true;
            t.backgroundColor = 0x2222ff;
            t.text = isShooting;
            t.selectable = false;
            t.setTextFormat(bulletTextFormat);
            sprite.addChild(t);
            return sprite;
        }


        
        private function spawnEnemy():void
        {
            var letter:String = String.fromCharCode(Keyboard.A + Math.random()*100%26);
            var enemySprite:Sprite = createEnemyGraphic(letter);
            var speed:Number = 1;
            var currEn:Enemy = new Enemy(50 + Math.random()*(stage.stageWidth-100), -20, 100, 100, speed, letter, enemySprite);
            enemyContainer.addChild(enemySprite);
            enemyList.push(currEn);
            isSpawningEnemy = false;
        }
        
        private function createEnemyGraphic(letter:String):Sprite
        {
            var s:Sprite = new Sprite();
            var t:TextField = new TextField();
            t.width = t.height = 25;
            t.background = true;
            t.backgroundColor = 0xff0000;
            t.text = letter;
            t.setTextFormat(enemyTextFormat);
            t.selectable = false;
            
            s.addChild(t);
            return s;
        }

        private function endGame():void
        {
            enemySpawnTimer.stop();
            enemySpawnTimer.removeEventListener(TimerEvent.TIMER, enemySpawnTick);
            removeEventListener(Event.ENTER_FRAME, updateGame);
            backToMenuTxt.visible = gameOverTxt.visible = true;
            stage.addEventListener(MouseEvent.CLICK, backToMenu);
        }

        private function backToMenu(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.CLICK, backToMenu);
            while(enemyList.length > 0)
            {
                var en:Enemy = enemyList.pop();
                en.kill();
            }
            
            while(bulletList.length > 0)
            {
                var b:Bullet = bulletList.pop();
                b.kill();
            }
            
            explosionContainer.graphics.clear();
            explosionList.length = 0;
            backToMenuTxt.visible = gameOverTxt.visible = false;
            
            mainMenu.visible = true;
            
            lives = 10;
            score = 0;
            stage.addEventListener(MouseEvent.CLICK, startGame);
        }
    }
}
import flash.utils.Timer;
import flash.geom.Point;
import flash.display.Sprite;
import flash.display.Graphics;

class Bullet
{
    public var sprite:Sprite = null;
    private var speed:Number = 0;
    public var letter:String = "";
    public var isDead:Boolean = false;
    
    function Bullet(s:Sprite, letter:String, speed:Number):void
    {
        this.sprite = s;
        this.letter = letter;
        this.speed = speed;
    }
    
    public function update():void
    {
        this.sprite.y -= speed;
    }
    
    public function kill():void
    {
        isDead = true;
        this.sprite.parent.removeChild(this.sprite);
    }
}


class PlayerGun
{
    public var sprite:Sprite = null;
    public var reloading:Boolean = false;
    
    private var reloadTime:int = 0;
    private var reload:int = 0;
    
    function PlayerGun(reloadTime:int):void
    {
        this.reload = this.reloadTime = reloadTime;
    }
    
    public function setSprite(s:Sprite):void
    {
        this.sprite = s;
    }

    public function reloadScale():Number
    {
        return reload/reloadTime;
    }

    
    public function update():void
    {
        if(reloading)
        {
            reload++;
            if(reload >= reloadTime)
            {
                reload = reloadTime;
                reloading = false;
            }
        }
    }
    
    public function fire():void
    {
        reload = 0;
        reloading = true;
    }


    public function move(x:int):void
    {
        this.sprite.x = x;
    }

    public function getPos():Point
    {
        return new Point(this.sprite.x, this.sprite.y);
    }


}



class Enemy
{
    private var hp:int = 0;
    private var maxHP:int = 0;
    private var speed:Number = 0;
    public var letter:String = "";
    public var sprite:Sprite = null;
    public var isDead:Boolean = false;
    
    function Enemy(x:int, y:int, hp:int, maxHP:int, speed:Number, letter:String, sprite:Sprite):void
    {
        this.hp = hp;
        this.maxHP = maxHP;
        this.speed = speed;
        this.letter = letter;
        this.sprite = sprite;
        sprite.x = x;
        sprite.y = y;
    }
    
    public function update():void
    {
        sprite.y +=speed;
    }
    
    public function kill():void
    {
        isDead = true;
        this.sprite.parent.removeChild(this.sprite);
    }
}

class Explosion
{
    public var sparks:Vector.<Spark> = new Vector.<Spark>();
    public static var MAX_LIFE:int = 30;
    public var life:int = MAX_LIFE;
    public var isDead:Boolean = false;
    
    public function  Explosion(x:int, y:int)
    {
        for(var i:int = 0 ; i < 10 ; i++)
        {
            sparks.push(new Spark(x, y));
        }
    }
    
    public function update():void
    {
        for each(var s:Spark in sparks)
            s.update();
        life--;
        if(life<=0)
            isDead = true;
    }
}


class Spark
{
    public var pos:Point = new Point();
    private var power:Point = new Point((Math.random()-0.5)*2, (Math.random()-0.5)*2);
    public function Spark(x:int, y:int)
    {
        this.pos = new Point(x, y);
    }
    
    public function update():void
    {
        this.pos = this.pos.add(power);
    }

}

