/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9dPR
 */

package {
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	
	/**
	 * ...
	 * @author ...
	 */
	 [ SWF(width=465,height=465,backgroundColor=0x000000) ]
    public class BitmapDataSample extends Sprite {
    	
		private var _bmd:BitmapData;
		private var _sprite:Sprite;
		
		//コンストラクタ
		public function BitmapDataSample() {
			_bmd = new BitmapData( 465, 465, false, 0x00000000 );
			addChild( new Bitmap( _bmd ) );
			
			//グラフィックの作成
			// 中心x, 中心y, 幅高さ, 色
			_sprite = newFig( 232, 232, 300, 0xffffff );
			
			
			var matrix:Matrix = new Matrix();
			//scale,rotate,transleateの順がベター
			matrix.scale( 0.8, 0.8 );
			matrix.rotate( 0.2 );
			matrix.translate( 0, 10 );
			//BitmapDataへ描画
			_bmd.draw(_sprite, matrix );
			
		}
    
        private function newFig( cx:Number, cy:Number, size:Number, col:uint ):Sprite {
            //中心(cx,cy), 幅高さsize, 色col　のグラフィックを生成
            var shape:Sprite = new Sprite();
            //shape.graphics.lineStyle( 12, 0xff0000, 0.3 );
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle( cx, cy, size*0.5 );
            shape.graphics.drawCircle( cx, cy, size*0.4 );
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            shape.graphics.drawRect( cx - w/2, cy - h/2, w, h ); 
            shape.graphics.endFill();
            return shape;
        }
    }
	
}