/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9d5m
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;

    public class FlashTest extends Sprite {
		private var _campus:Sprite;
		private var _color:uint;
		private var _frame:uint;
		
        public function FlashTest() {
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			reset();
			_campus = new Sprite();
			this.addChild(_campus);
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			++_frame;
			if (_frame > 60) {
				reset();
			}
			
			var padding:uint = 15;
			var num:uint = 465 / padding + 1;

			var ratio:Number = _frame / 60;
			
			var g:Graphics = _campus.graphics;
			g.clear();
			g.lineStyle(1, _color);
			for (var index:uint = 0; index < num; ++index) {
				var a:Number = (index + 1) * padding * ratio;
				var b:Number = 465 - ((index + 1) * padding * ratio);
				
				g.moveTo(0, a); g.lineTo(a, 0);
				g.moveTo(465, a); g.lineTo(a, 465);
				g.moveTo(0, a); g.lineTo(b, 465);
				g.moveTo(465, a); g.lineTo(b, 0);
			}
		}
		
		private function reset():void {
			_frame = 0;
			var r:uint = 128 + (Math.random() * 128);
			var g:uint = 128 + (Math.random() * 128);
			var b:uint = 128 + (Math.random() * 128);
			_color = (r << 16) + (g << 8) + (b << 0);
		}
    }
}