/**
 * Copyright blashstar ( http://wonderfl.net/user/blashstar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ctu
 */

// forked from mimshwright's Filter demo for colors
// forked from mimshwright's Filter demo with blur and drop shadow
package
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event; 
    import flash.net.URLRequest;
    
    import org.as3lib.kitchensync.*;
    import org.as3lib.kitchensync.action.*;
    import org.as3lib.kitchensync.action.group.*;
    import org.as3lib.kitchensync.action.tween.*;
    import org.as3lib.kitchensync.utils.FrameRateView;
    
    [SWF(width='500', height='500', backgroundColor='#FFFFFF', frameRate='60')]
    public class FilterTest extends Sprite {
        private var bg:Sprite;
        private var image:Loader;
        
        public function FilterTest() {
            KitchenSync.initialize(this, "2.0");
            
            // add a framerate display
            addChild(new FrameRateView());
            
            image = new Loader();
            image.contentLoaderInfo.addEventListener( Event.COMPLETE, onImageLoaded );
            image.load( new URLRequest( "http://farm3.staticflickr.com/2185/2533156638_110238b63f.jpg"));
            
        }    
        
        private function onImageLoaded(event:Event):void {
            addChild(image);
            
            var satTween:KSTween = TweenFactory.newTweenWithTargets(new SaturationTweenTarget(image, 0, -1), "2s");
            var contTween:KSTween = TweenFactory.newTweenWithTargets(new ContrastTweenTarget(image, 0, 1), "2s");
            var brtTween:KSTween = TweenFactory.newTweenWithTargets(new BrightnessTweenTarget(image, 0, -1), "2s");
            var tintTween:KSTween = TweenFactory.newTintTween( image, TintTweenTarget.CURRENT_TINT, 0x00FF00, 0.5, "2s");
            
            new KSSequenceGroup ( 
                satTween,
                contTween,
                brtTween,
                tintTween
            ).start();
        }
    }
}