/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9cPL
 */

// forked from bkzen's flash on 2011-5-17
package  
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    
    /**
     * 
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test48 extends Sprite 
    {
        private var workSpace: Sprite;
        private var box: Box;
        private var hand1: Sprite;
        private var hand2: Sprite;
        private var frame: int
        private var mtx:Matrix;
        
        public function Test48() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            
            addChild(workSpace = new Sprite());
            workSpace.x = workSpace.y = 50;
            var g: Graphics = workSpace.graphics;
            g.lineStyle(0);
            g.moveTo(-100, 0);
            g.lineTo( 500, 0);
            g.moveTo( 0, -100);
            g.lineTo( 0,  500);
            g.endFill();
            g.beginFill(0xCC0000, 0.3);
            g.drawRect(0, 0, 100, 100);
            workSpace.addChild(box = new Box());
            workSpace.addChild(hand1 = makeHand(0x0080FF));
            workSpace.addChild(hand2 = makeHand(0x00FF80));
            hand1.x = hand1.y = 50;
            hand2.x = hand2.y = 200;
            mtx = new Matrix();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function makeHand(color: uint): Sprite
        {
            var sp: Sprite = new Sprite();
            var g: Graphics = sp.graphics;
            g.beginFill(color);
            g.drawCircle(0, 0, 5);
            sp.buttonMode = true;
            sp.addEventListener(MouseEvent.MOUSE_DOWN, function(e: Event): void {
                sp.startDrag();
            })
            sp.addEventListener(MouseEvent.MOUSE_UP, function(e: Event): void { 
                sp.stopDrag();
                sp.x |= 0;
                sp.y |= 0;
            });
            return sp;
        }
        
        private function loop(e: Event): void 
        {
            frame ++;
            mtx.a = mtx.d = 1, mtx.b = mtx.c = mtx.tx = mtx.ty = 0; // 初期化
            mtx.translate( - hand1.x, - hand1.y); // どこを中心に回転するか。(ちょっとわかりにくいけど)
            mtx.rotate(frame * Math.PI / 180); // 回転
            mtx.translate( hand2.x, hand2.y); // どこに描画するか
            box.draw(mtx);
        }
        
    }
}
import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
class Box extends Sprite
{
    private var points: Array;
    private var labels: Array;
    private const out: String = "(x, y)";
    function Box()
    {
        points = [new Point(0, 0), new Point(100, 0), new Point(100, 100), new Point(0, 100)];
        labels = [crateLabel(), crateLabel(), crateLabel(), crateLabel()];
        draw(new Matrix(1, 0, 0, 1, 100, 100));
    }
    
    public function draw(mtx: Matrix): void
    {
        var i: uint, n: uint = 4;
        var g: Graphics = graphics;
        g.clear();
        g.beginFill(0xCC0000);
        for (i = 0; i < n; i++) 
        {
            var p: Point = points[i];
            var px: Number = p.x * mtx.a + p.y * mtx.c + mtx.tx;
            var py: Number = p.x * mtx.b + p.y * mtx.d + mtx.ty;
            if (i == 0) g.moveTo(px, py);
            else g.lineTo(px, py);
            var txt: TextField = labels[i];
            txt.text = out.replace("x", px).replace("y", py);
            txt.x = px, txt.y = py;
        }
    }
    
    private function crateLabel(): TextField
    {
        var txt: TextField = new TextField();
        txt.autoSize = TextFieldAutoSize.LEFT;
        addChild(txt);
        return txt;
    }
}