/**
 * Copyright hgw ( http://wonderfl.net/user/hgw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9c37
 */

package
{
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.Timer;

	public class EffectScketch extends Sprite
	{
		
		private var BMP_WIDTH:Number;
		private var BMP_HEIGHT:Number;
		
		private var _scale:Number = 8;
		
		private var SCALE_MAX_X:int = 2;
		private var SCALE_MAX_Y:int = 2;
		private const ZERO_POINT:Point = new Point();;
		
		private var _noiseMapSrc:BitmapData;
		private var _noiseMapOutput:BitmapData;
		private var _noiseMapOutputMatrix:Matrix;
		
		private var _offsetArray:Array;
		private var _speedArray:Vector.<Point>;
		
		private var _dmf:DisplacementMapFilter;

		private var _numOctvas:int = 3;
		private var _filterScaleX:Number = 0;
		private var _filterScaleY:Number = 0;
		private var _filterColor:Number = 0;
		private var _filterAlpha:Number = 0;

		private var tObj:Object;

		private var img:Bitmap = new Bitmap(null, PixelSnapping.NEVER, false);		
		

		public function EffectScketch()
		{
			init();
		}
		
		private function init():void
		{
			stage.quality = StageQuality.LOW;
			img.bitmapData = makeStripe();
			addChild( img );
			DMFEffecter( 465, 600);
			var t:Timer = new Timer(1000/60);
			t.addEventListener( TimerEvent.TIMER, update);
			t.start();
			tObj = new Object();
			tObj.scvalue = 5;
			keepTween();
		}
		
		private function keepTween():void
		{
			var sctraget:Number = (tObj.scvalue==5)? 1:5;

			Tweener.addTween( tObj, {scvalue:sctraget, time:10, onComplete:keepTween, transition:Equations.easeNone});
		}
		
		private function update(e:Event):void
		{
			updateScale( tObj.scvalue );
			updateEffect(); 
			img.filters = [getFilter()];//, new ColorMatrixFilter([1/3, 1/3, 1/3, 0, 0, 1/3, 1/3, 1/3, 0, 0,1/3, 1/3, 1/3, 0, 0,0, 0, 0, 1, 0])];
		}
		
		private function makeStripe():BitmapData
		{
			var h:int = 465*2;
			var stripenum:int = 200;
			var colorPattern:Array = new Array( 0x0*Math.random(), 0xFFFFFF);
			
			var result:BitmapData = new BitmapData( 465, h, false, 0x0);
			
			var rect:Rectangle = new Rectangle( 0, 0, 465, Math.ceil(h/stripenum) );
			
			for(var i:int=0; i<stripenum; i++)
			{
				rect.y = i*Math.ceil(h/stripenum);
				result.fillRect( rect, colorPattern[ Math.ceil(i%colorPattern.length) ]);
			}
			return result;
		}
		
		public function DMFEffecter(w_:Number, h_:Number):void
		{
			BMP_WIDTH = w_/_scale;
			BMP_HEIGHT = h_/_scale;
			
			_noiseMapOutputMatrix = new Matrix();
			_noiseMapOutput = new BitmapData( w_, h_, true, 0x0);
			_noiseMapSrc = new BitmapData(BMP_WIDTH, BMP_HEIGHT, true, 0x0);
			_dmf = new DisplacementMapFilter(null,null,BitmapDataChannel.RED,BitmapDataChannel.BLUE,0,0,DisplacementMapFilterMode.IGNORE,0,0);

			_noiseMapOutputMatrix.scale( _scale, _scale);
			initOffsetArray(_numOctvas);
		}

		private function initOffsetArray(octaves:int):void
		{
			_offsetArray = new Array();
			_speedArray = new Vector.<Point>();
			if(octaves>0)
			{
				for(var i:int=0; i<octaves; i++)
				{
					_offsetArray.push( new Point(0, 0) )
					_speedArray.push( new Point( 4*(int(Math.random()*2)==0? -1:1), 4*(int(Math.random()*2)==0? -1:1) ));
				}
			}
		}
		
		public function updateEffect():void
		{
			for (var i:int=0; i<_numOctvas; i++)
			{
				_offsetArray[i].x += _speedArray[i].x;
				_offsetArray[i].y += _speedArray[i].y;
			}
			updateNoise();
		}

		public function updateScale(vel_:Number):void
		{
			_filterScaleY = SCALE_MAX_Y*(1-vel_);
			_filterScaleX = SCALE_MAX_X*(1-vel_);
		}

		private function updateNoise():void
		{
			_noiseMapSrc.fillRect( _noiseMapSrc.rect, 0x0 );

			var baseX:Number = BMP_WIDTH;
			var baseY:Number = BMP_HEIGHT;
			var numOctvas:Number = _numOctvas;
			var randomSeed:Number = 0;
			var stitch:Boolean = false;
			var fractalNoise:Boolean = false;
			var numOctaves:int = 5;
			var channelOptions:uint = 4;
			var grayScale:Boolean = true;
			
			_noiseMapSrc.perlinNoise(
				baseX,
				baseY, 
				numOctaves, 
				randomSeed, 
				stitch, 
				fractalNoise,
				channelOptions, 
				grayScale, 
				_offsetArray
			);
		}
		
		public function getFilter():DisplacementMapFilter
		{
			_noiseMapOutput.fillRect( _noiseMapOutput.rect, 0x0 );
			_noiseMapOutput.draw( _noiseMapSrc, _noiseMapOutputMatrix );
			
			_dmf.mapBitmap = _noiseMapOutput;
			_dmf.mapPoint= ZERO_POINT;
			_dmf.scaleX = _filterScaleX;
			_dmf.scaleY = _filterScaleY;
			return _dmf;		
		}
		
		public function getMapBitmapData():BitmapData
		{
			_noiseMapOutput.fillRect( _noiseMapOutput.rect, 0x0 );
			_noiseMapOutput.draw( _noiseMapSrc, _noiseMapOutputMatrix );
			return _noiseMapOutput;
		}
	}
}
		
