/**
 * Copyright kinihon ( http://wonderfl.net/user/kinihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9blo
 */

package
{
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    [SWF(frameRate=60,backgroundColor=0xffffff)]
    public class Ahiru extends Sprite
    {
        private var num:int = 100;
        private var px:Vector.<Number >  = new Vector.<Number > (num + 1);
        private var py:Vector.<Number >  = new Vector.<Number > (num + 1);
        private var boats:Vector.<MovieClip>=new Vector.<MovieClip>();
        private var shape:Shape=new Shape();
        private var boatsCanvas:Sprite=new Sprite();
        private const commands:Vector.<int> = Vector.<int>([1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]);
        private const points:Vector.<Number> = Vector.<Number>([-35,-43,-35,-42,-35,-41,-35,-40,-35,-38,-35,-37,-35,-35,-34,-32,-33,-31,-33,-30,-32,-30,-32,-28,-31,-27,-30,-26,-30,-25,-29,-25,-29,-24,-28,-23,-27,-22,-27,-21,-26,-21,-25,-21,-25,-20,-25,-19,-24,-19,-23,-18,-23,-17,-22,-16,-21,-16,-20,-15,-19,-15,-19,-14,-18,-13,-16,-12,-15,-11,-14,-11,-14,-10,-12,-9,-11,-9,-10,-9,-9,-8,-9,-7,-7,-6,-6,-6,-6,-5,-4,-4,-2,-4,-2,-3,-1,-3,0,-3,1,-3,2,-3,3,-3,4,-3,5,-3,6,-3,7,-3,8,-3,10,-3,11,-3,12,-3,13,-3,14,-3,15,-3,16,-3,17,-3,17,-4,17,-5,18,-5,20,-6,21,-6,22,-6,23,-7,24,-8,25,-9,26,-10,27,-11,27,-12,28,-13,28,-14,29,-15,30,-16,31,-16,32,-18,32,-19,33,-20,33,-21,34,-22,35,-24,35,-25,36,-26,36,-29,37,-30,38,-30,38,-31,38,-32,39,-32,40,-34,40,-35,41,-35,41,-36,41,-37,41,-38,41,-39,41,-40,41,-41,41,-42,41,-43,41,-44,41,-45,41,-46,43,-46,45,-47,46,-47,47,-49,49,-50,50,-50,51,-51,52,-52,53,-53,54,-54,55,-55,55,-56,56,-57,56,-58,57,-58,59,-59,59,-60,59,-61,59,-62,60,-64,60,-66,60,-68,60,-70,60,-73,60,-76,60,-77,60,-79,60,-81,60,-83,59,-84,59,-85,57,-87,56,-88,55,-88,54,-88,53,-89,51,-89,50,-89,49,-89,47,-89,45,-90,44,-90,41,-90,39,-90,36,-90,33,-90,32,-90,30,-90,29,-90,28,-90,27,-90,26,-90,24,-90,24,-89,23,-89,23,-87,22,-85,22,-84,22,-83,22,-82,22,-81,21,-79,21,-78,21,-77,20,-76,20,-75,20,-74,20,-73,20,-72,20,-71,20,-70,20,-69,20,-68,20,-67,20,-66,20,-65,20,-63,20,-62,20,-61,20,-60,20,-59,20,-57,21,-57,22,-56,22,-55,23,-55,23,-54,23,-55,22,-55,21,-55,19,-55,15,-55,13,-55,10,-55,7,-55,5,-55,3,-55,1,-55,-1,-55,-3,-55,-5,-55,-7,-55,-8,-55,-10,-55,-12,-55,-14,-55,-15,-55,-17,-55,-18,-55,-19,-55,-20,-55,-21,-55,-22,-55,-23,-54,-25,-54,-26,-53,-27,-53,-28,-53,-29,-52,-30,-52,-31,-51,-32,-51,-33,-51,-33,-50,-35,-50,-35,-49,-35,-48,-36,-48,-36,-47,-36,-46,33,-71,33,-72,33,-73,33,-74,34,-74,34,-75,36,-75,37,-75,38,-76,39,-76,40,-76,41,-76,42,-76,42,-75,43,-74,43,-73,44,-73,44,-72,44,-71,62,-64,61,-64,62,-64,64,-64,67,-65,69,-65,71,-65,72,-65,73,-63,74,-62,75,-62,76,-61,78,-60,79,-60,79,-59,79,-58,79,-57,80,-57,80,-56,81,-56,81,-55,82,-55,82,-54,81,-54,80,-54,79,-54,78,-54,77,-54,76,-54,74,-54,73,-54,72,-53,71,-53,70,-53,69,-53,68,-53,67,-53,66,-53,65,-53,64,-53,63,-53,62,-53,61,-53,60,-53,59,-53,58,-53,57,-53,56,-53,55,-53,54,-53,53,-53,52,-53,51,-53,50,-53,49,-53,58,-57,60,-57,62,-57,63,-57,64,-57,65,-57,66,-57,67,-57,69,-57,70,-57,71,-57,72,-57,73,-57,74,-57,76,-57,77,-57,78,-57,79,-57,12,-43,11,-43,10,-43,8,-43,6,-43,5,-43,2,-43,0,-43,-2,-43,-3,-43,-4,-43,-5,-43,-6,-43,-8,-43,-9,-43,-11,-43,-12,-43,-13,-43,-14,-42,-15,-42,-16,-42,-16,-41,-17,-41,-17,-40,-17,-39,-17,-38,-16,-36,-15,-36,-15,-35,-14,-34,-13,-32,-13,-31,-12,-29,-11,-28,-10,-27,-9,-26,-8,-25,-6,-24,-5,-23,-3,-22,-2,-22,-1,-21,1,-21,2,-21,4,-20,5,-20,6,-20,7,-20,9,-21,10,-21,11,-22,11,-23,12,-24,13,-24,14,-24,14,-25,15,-25,15,-26,16,-27,17,-27,17,-29]);

        public function Ahiru()
        {
            addChild(boatsCanvas);
            addChild(shape);
            for (var i:int=0; i<=num; i++)
            {
                px[i]=i*(stage.stageWidth/num);
                py[i] = stage.stageHeight;
            }
            stage.addEventListener(Event.ENTER_FRAME,_enterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,_mouseDown);
        }
        private function _enterFrame(event:Event):void
        {
            shape.graphics.clear();
            for (var i:int=num; i>0; i--)
            {
                py[i] = py[i - 1];
            }
            py[0] += (mouseY-py[0])*0.1;
            shape.graphics.beginFill(0x00ffff,0.5);
            shape.graphics.moveTo(0,stage.stageHeight);
            shape.graphics.lineTo(px[0],py[0]);
            for (i=1; i<=num; i++)
            {
                shape.graphics.lineTo(px[i],py[i]);
            }
            shape.graphics.lineTo(stage.stageWidth,stage.stageHeight);
            shape.graphics.endFill();
            for (i=0; i<boats.length; i++)
            {
                if (boats[i])
                {
                    var id:int = Math.round(boats[i].x / stage.stageWidth * num);
                    if (id > 0 && id < num)
                    {
                        //水にめり込む
                        boats[i].y = py[id]+20;
                        boats[i].rotation=Math.atan2((py[id+1]-py[id-1]),(px[id+1]-px[id-1]))*180/Math.PI;
                        //↓進む
                        boats[i].x+=boats[i].speed;
                    }else{
                        boatsCanvas.removeChild(boats[i]);
                        boats[i]=null;
                    }
                }
            }
        }
        private function _mouseDown(event:MouseEvent):void{
            addMc(mouseX);
        }
        private function addMc(X:Number):void
        {
            if (Math.round(X / stage.stageWidth * num) > 0 && Math.round(X / stage.stageWidth * num) < num)
            {
                var id:int = boats.length;
                boats[id]=new MovieClip();
                boats[id].x = X;
                boats[id].graphics.lineStyle(1);
                boats[id].graphics.drawPath(commands,points);
                boatsCanvas.addChild(boats[id]);
                boats[id].scaleX*=0.5;
                boats[id].scaleY*=0.5;
                boats[id].speed=Math.random()+0.2;
            }
        }

    }
}