/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9bez
 */

// forked from yonatan's forked from: Mandelbrot
// forked from rect's Mandelbrot
//
// tesselated rendering (click to see it in action), 256x256 px, 60 iterations

package
{
    import flash.events.*;
    import flash.display.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;
    import flash.ui.Mouse;
    import flash.text.*;
    
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000")]
    
    public class main extends Sprite
    {
        private const w:uint = 256;
        private const h:uint = 256;
        private var cont:Bitmap;
        private var zero:Point = new Point(0,0);
        private var bmd:BitmapData;
        private var buffer:Vector.<uint>;

        private var zoom:Number = 1;
        private var mx:Number = -0.5;
        private var my:Number = 0;
        private var maxIteration:int = 60;
        private var rot:Number = 0;
        
        private var fill:Boolean = true;
        private var text:TextField;
        
        public function main():void
        {
            stage.frameRate = 30;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.MEDIUM;
            Mouse.cursor = flash.ui.MouseCursor.BUTTON;
            
            bmd = new BitmapData(w, h, false, 0x000000);
            cont = new Bitmap(bmd);
            addChild(cont);
            cont.width = stage.stageWidth;
            cont.height = stage.stageHeight;
            cont.x = (stage.stageWidth - cont.width) / 2;
            cont.y = (stage.stageHeight - cont.height) / 2;
            
            text = new TextField;
            text.width = cont.width;
            text.visible = false;
            addChild( text );

            buffer = new Vector.<uint>( w*h, true );

            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK, function(e:*):void{ text.visible = !(fill = !fill) });
        }

        private function update(e:Event):void
        {
            var pixels:uint = w * h;
            
            rot += 5;
            zoom = 1.75 + (Math.sin(rot /5 * Math.PI/180));
            mx = (Math.sin(rot * Math.PI/180) * 0.25) -1;
            my = Math.sin(rot * Math.PI/180) * 0.28;
            
            cRe = (cRe*3 + cont.mouseX / cont.width - 1)/4;
            cIm = (cIm*3 + cont.mouseY / cont.height )/4;
            
            text.text = "C = " + cRe + " + " + cIm + "i";
            
            for (var j:int = 0; j < pixels; j++) buffer[j]=0;

            tesselate( 0, 0,w-1,h-1 );

            bmd.setVector(bmd.rect, buffer);
        }
        
        private function tesselate( x1:uint, y1:uint, x2:uint, y2:uint ):void {
            if( x2==x1 && y2==y1 ) return;
            
            var x:uint, y:uint;
            var color:uint = getAndSetPixel( x1, y1 );
            var split:Boolean = false;

            for( x=x1; x<=x2; x++ ) {
                split = split || (color != getAndSetPixel( x, y1 ));
                split = split || (color != getAndSetPixel( x, y2 ));
            }
            for( y=y1; y<=y2; y++ ) {
                split = split || (color != getAndSetPixel( x1, y ));
                split = split || (color != getAndSetPixel( x2, y ));
            }
            
            if( x2-x1 < 2 && y2-y1 < 2 ) return;
            if( split ) {
                if( x2-x1 > y2-y1 ) {
                    tesselate( x1, y1, (x1+x2)/2, y2 );
                    tesselate( (x1+x2)/2, y1, x2, y2 );
                } else {
                    tesselate( x1, y1, x2, (y1+y2)/2 );
                    tesselate( x1, (y1+y2)/2, x2, y2 );
                }
            } else {
                if( !fill ) color = 0xFFCC8800;
                for( y = y1+1; y < y2; y++ ) {
                    for( x = x1+1; x < x2; x++ ) {
                        buffer[y*w+x] = color;
                    }
                }
            }                
        }
        
        private function getAndSetPixel( x:int, y:int ):uint {
            var idx:uint = y*w+x;
            if( buffer[idx] == 0 ) {
                //var i:uint = calc( 1.5 * (x - w/2) / (zoom * w/2) + mx, (y - h/2) / (zoom * h/2) + my );
                var i:uint = calc( (x - w/2) / (zoom * w/2), (y - h/2) / (zoom * h/2) );
                var hsv:ColorHSV = new ColorHSV((i + 192*Math.atan2(cIm,cRe)), 0.9, (240 * Number(i < maxIteration))*0.01, 1);
                var rgb:uint = hsv.value;
                buffer[idx] = rgb | 0xFF000000;
            }
            return buffer[idx];
        }
        
        protected var cRe:Number = -1;
        protected var cIm:Number = 0;

        private function calc( pr:Number, pi:Number ):uint {
            var newRe:Number = pr;
            var newIm:Number = pi;
            var oldRe:Number = 0;
            var oldIm:Number = 0;
            var oldReSqr:Number = 0;
            var oldImSqr:Number = 0;
            var i:int = 0;
            
            for(i= 0; i < maxIteration; i++)
            {
                oldRe = newRe;
                oldIm = newIm;
                oldReSqr = oldRe * oldRe;
                oldImSqr = oldIm * oldIm;
                
                newRe = oldReSqr - oldImSqr + cRe;
                newIm = 2 * oldRe * oldIm + cIm;
                
                if((oldReSqr + oldImSqr) > 4) break;
            }
            
            return i;
        }

    }
}