/**
 * Copyright Ricki_G ( http://wonderfl.net/user/Ricki_G )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9bIW
 */

//playing around with something Zevan Rosser from http://actionsnippet.com/?p=1236 did
//on his blog

package {
	
	import flash.display.*;
	import flash.events.*;
	
	[SWF( width="512", height = "512", backgroundColor = "0x222222", frameRate = "30" )]
	
	public class RandomWalk extends Sprite 
	{
		
		private var _canvas:BitmapData;
		private var _count:int = 100;
		private var _movers:Vector.<Mover>;
		
		public function RandomWalk()
		{
			var w:Number = 512;
			var h:Number = 512;
			scaleX=scaleY = 0.25;
			_canvas = new BitmapData( w * 4, h * 4, false, 0x222222 );
			addChild( new Bitmap( _canvas ));
			
			_movers = new Vector.<Mover>();
			
			for ( var i:int = 0; i < _count; i++ ) 
			{
				_movers[ i ] = new Mover( _canvas, w * 1.5 + Math.random() * w, h * 1.5 + Math.random() * h );
			}
			addEventListener( Event.ENTER_FRAME, onRun );
		}
		private function onRun( evt:Event ):void 
		{
			for (var i:int = 0; i < 200; i++) 
			{
				for (var j:int = 0; j < _count; j++) 
				{
					_movers[ j ].run();
				}
			}
		}
	}
}

import flash.display.BitmapData;
class Mover 
{
	public var x:Number;
	public var y:Number;
	public var velX:Number;
	public var velY:Number;
	public var speed:Number;
	private var _canvas:BitmapData;
	private var _color:uint;
	
	public function Mover( canvas:BitmapData, xp:Number, yp:Number ) 
	{
		_color = Math.random() * 0xFFFFFF;
		_canvas = canvas;
		x = xp;
		y = yp;
		velX = 0;
		velY = 0;
		speed=Math.random() * 5 - 2.5;
	}
	
	public function run():void 
	{
		x += velX;
		y += velY;
		_canvas.setPixel( x, y, _color );
		
		var dir:Number = int( Math.random() * 4 );
		
		if (dir == 0) 
		{
			velX = 0;
			velY =- speed;
		} 
		else if (dir == 1) 
		{
			velX = 0;
			velY = speed;
		} 
		else if (dir == 2) 
		{
			velX =- speed;
			velY = 0;
		} 
		else if (dir == 3) 
		{
			velX = speed;
			velY = 0;
		}
	}
}
