/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9aoa
 */

/*パズル的な何か。ゲームではありません。
 * 
 * 左上の3種のボタンをクリックすると、同じ絵のパネルが生成され、
 * ドラッグ状態になります。
 * そのまま中央の水色の正方形の上でマウスアップすると、
 * パネルが正方形の上に配置されます。
 * （それ以外の場所でマウスアップするとパネルはremoveChildされます）
 * 
 * パネルの中央部分をマウスダウン→ドラッグ
 * パネルの端っこをクリック→90度回転
 * この操作を使って、パネルで閉路を作ってください。
 * 
 * 「CHECK」ボタンを押すと、パネルが閉路を形成しているかどうか判定します。
 * （応用しだいではゲームになるかも…？）
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.text.TextField;

	[SWF(width="465",height="465")]
	public class Test1 extends Sprite{
		public var squares:Vector.<Vector.<Square>>
		public const NUM_X:uint = 6;
		public const NUM_Y:uint = 4;
		public var result:TextField;
		public function Test1(){
			squares = new Vector.<Vector.<Square>>(NUM_Y, true);
			for (var j:int = 0; j < NUM_Y; j++) {
				squares[j] = new Vector.<Square>();
				for (var i:int = 0; i < NUM_X; i++) {
					var s:Square = addChild(new Square(i * 60 + 60, j * 60 + 50)) as Square;
					s.positionX = i; s.positionY = j;
				}	
			}
			//右と左の手をもつパネルを生成するボタン
			var sButton:Sprite = addChild(new Sprite()) as Sprite;
			sButton.graphics.lineStyle(2, 0x000000);
			sButton.graphics.beginFill(0xFFFFFF);
			sButton.graphics.drawRect(0, 0, 40, 40);
			sButton.graphics.endFill();
			sButton.graphics.moveTo(0, 20);
			sButton.graphics.lineTo(40, 20);
			sButton.x = 5; sButton.y = 5;
			sButton.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				var newPanel:StraightLinePanel = addChild(new StraightLinePanel()) as StraightLinePanel;
				newPanel.startDrag(true);
			});
			//右と下の手をもつパネルを生成するボタン
			var bButton:Sprite = addChild(new Sprite()) as Sprite;
			bButton.graphics.lineStyle(2, 0x000000);
			bButton.graphics.beginFill(0xFFFFFF);
			bButton.graphics.drawRect(0, 0, 40, 40);
			bButton.graphics.endFill();
			bButton.graphics.moveTo(40, 20);
			bButton.graphics.lineTo(20, 20);
			bButton.graphics.lineTo(20, 40);
			bButton.x = 50; bButton.y = 5;
			bButton.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				var newPanel:BentLinePanel = addChild(new BentLinePanel()) as BentLinePanel;
				newPanel.startDrag(true);
			});
			//右と下と左の手をもつパネルを生成するボタン
			var tButton:Sprite = addChild(new Sprite()) as Sprite;
			tButton.graphics.lineStyle(2, 0x000000);
			tButton.graphics.beginFill(0xFFFFFF);
			tButton.graphics.drawRect(0, 0, 40, 40);
			tButton.graphics.endFill();
			tButton.graphics.moveTo(0, 20);
			tButton.graphics.lineTo(40, 20);
			tButton.graphics.moveTo(20, 20);
			tButton.graphics.lineTo(20, 40);
			tButton.x = 95; tButton.y = 5;
			tButton.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				var newPanel:TLinePanel = addChild(new TLinePanel()) as TLinePanel;
				newPanel.startDrag(true);
			});
			//閉路かどうか判定するボタン
			var checkButton:Sprite = addChild(new Sprite()) as Sprite;
			checkButton.graphics.beginFill(0xFFFF00);
			checkButton.graphics.drawCircle(0, 0, 30);
			checkButton.graphics.endFill();
			checkButton.x = 60;
			checkButton.y = 350;
			var checkBtnText:TextField = checkButton.addChild(new TextField())as TextField;
			checkBtnText.text = "CHECK";
			checkBtnText.x = -22; checkBtnText.y = -10;
			checkBtnText.selectable = false;
			checkButton.addEventListener(MouseEvent.CLICK, check);
			
			//結果を表示するテキスト
			result = addChild(new TextField()) as TextField;
			result.x = 100; result.y = 300; result.width = 300; result.height = 150;
			result.border = true; result.background = true;
		}
		
		private function check(e:MouseEvent):void {
			result.text = "";
			var panels:Vector.<PanelBase> = new Vector.<PanelBase>();
			for (var ind:int = 0; ind < numChildren; ind++) {
				var child:DisplayObject = getChildAt(ind);
				if (child is PanelBase) panels.push(child);
			}
			var posVec:Vector.<Vector.<PanelBase>> = new Vector.<Vector.<PanelBase>>(NUM_Y, true);
			for (var k:int = 0; k < NUM_Y; k++) {
				posVec[k] = new Vector.<PanelBase>(NUM_X, true);
			}
			panels.forEach(
				function(item:PanelBase, index:uint, vector:Vector.<PanelBase>):void {
					posVec[item.position.positionY][item.position.positionX] = item;
				}	
			);
			//trace(posVec.toString());
			var checkVec:Vector.<Vector.<Boolean>> = new Vector.<Vector.<Boolean>>(NUM_Y,true);
			for (var l:int = 0; l < NUM_Y; l++) {
				checkVec[l] = new Vector.<Boolean>(NUM_X, true);
			}
			
			var up:Boolean;
			var right:Boolean;
			var down:Boolean;
			var left:Boolean;
			
			for (var j:int = 0; j < NUM_Y; j++) {
				for (var i:int = 0; i < NUM_X; i++) {
					if (posVec[j][i]) {
						up = right = down = left = true;
						//上の手をもっている場合次の判定を行う。
						//　→　今見ているパネルが2段目以下、かつ上にパネルが存在し、下の手をもっているならtrue。
						//以下、右下左について同様。
						if (posVec[j][i].hand.hasUp) {
							if (j > 0 && posVec[j - 1][i]) up = posVec[j - 1][i].hand.hasDown;
							else up = false;
						}
						if (posVec[j][i].hand.hasRight) {
							if (i < NUM_X - 1 && posVec[j][i + 1]) right = posVec[j][i + 1].hand.hasLeft;
							else right = false;
						}
						if (posVec[j][i].hand.hasDown) {
							if (j < NUM_Y - 1 && posVec[j + 1][i]) down = posVec[j + 1][i].hand.hasUp;
							else down = false;
						}
						if (posVec[j][i].hand.hasLeft) {
							if (i > 0 && posVec[j][i - 1]) left = posVec[j][i - 1].hand.hasRight;
							else left = false;
						}
						checkVec[j][i] = up && right && down && left;//判定した全ての手がtrueならばtrue
						//if (!checkVec[j][i]) trace("(",j,i,up, right, down, left, ")");
					}
				}
				result.appendText(checkVec[j].toString());
				result.appendText("\n")
			}
			//falseがあるかどうか判定
			if (result.text.search("false") == -1) result.appendText("\n\n閉路が完成しました！");
			else result.appendText("\n\n閉路になっていません。");
		}
		
	}
}
import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;
class Square extends Sprite {
	public var positionX:uint;
	public var positionY:uint;
	private var g:Graphics;
	public function Square(_x:Number, _y:Number){
		g = this.graphics;
		g.lineStyle(2, 0x666666);
		g.beginFill(0x99FFFF);
		g.drawRect(0, 0, 60, 60);
		g.endFill();
		x = _x; y = _y;
	}
}
import flash.display.Sprite;
import flash.display.Graphics;
class PanelBase extends Sprite{
	public var hand:Hand;
	public var position:Square;
	private var g:Graphics;
	public function PanelBase(){
		g = this.graphics;
		createPanel();
		hand = new Hand(false, false, false, false);
		
		addEventListener(MouseEvent.CLICK, rotate);
		addEventListener(MouseEvent.MOUSE_DOWN, drag);
		addEventListener(MouseEvent.MOUSE_UP, put);
		addEventListener(Event.REMOVED_FROM_STAGE, remove);
	} 
	
	protected function createPanel():void {
		g.lineStyle();
		g.beginFill(0xFFFFFF);
		g.drawRect(-30, -30, 60, 60);
		g.endFill();
	}
	
	private function rotate(e:MouseEvent):void {
		if (e.localX < -15 || e.localX > 15 || e.localY < -15 || e.localY > 15) {
			hand.rotate();
			rotation += 90;
		}
	}
	private function drag(e:MouseEvent):void {
		if (e.localX > -15 && e.localX < 15 && e.localY > -15 && e.localY < 15) {
			startDrag(true);
		}
	}
	private function put(e:MouseEvent):void {
		stopDrag();
		if(dropTarget is Square){
			this.x = dropTarget.x + 30;
			this.y = dropTarget.y + 30;
			position = dropTarget as Square;
		}else {
			parent.removeChild(this);
		}
	}
	private function remove(e:Event):void {
		removeEventListener(Event.REMOVED_FROM_STAGE, remove);
		removeEventListener(MouseEvent.CLICK, rotate);
		removeEventListener(MouseEvent.MOUSE_DOWN, drag);
		removeEventListener(MouseEvent.MOUSE_UP, put);
		hand = null; g = null;
	}
}

class StraightLinePanel extends PanelBase {
	public function StraightLinePanel() {
		createPanel();
		hand.hasRight = true;
		hand.hasLeft = true;
	}
	
	override protected function createPanel():void 
	{
		super.createPanel();
		graphics.lineStyle(3, 0x000000);
		graphics.moveTo(-30, 0);
		graphics.lineTo(30, 0);
	}
}

class BentLinePanel extends PanelBase {
	public function BentLinePanel() {
		createPanel();
		hand.hasRight = true;
		hand.hasDown = true;
	}
	
	override protected function createPanel():void 
	{
		super.createPanel();
		graphics.lineStyle(3, 0x000000);
		graphics.moveTo(30, 0);
		graphics.lineTo(0, 0);
		graphics.lineTo(0, 30);
	}
}

class TLinePanel extends PanelBase {
	public function TLinePanel() {
		createPanel();
		hand.hasRight = true;
		hand.hasDown = true;
		hand.hasLeft = true;
	}
	
	override protected function createPanel():void 
	{
		super.createPanel();
		graphics.lineStyle(3, 0x000000);
		graphics.moveTo(-30, 0);
		graphics.lineTo(30, 0);
		graphics.moveTo(0, 0);
		graphics.lineTo(0, 30);
	}
}

class Hand extends EventDispatcher {
	public var hasUp:Boolean = false;
	public var hasRight:Boolean = false;
	public var hasDown:Boolean = false;
	public var hasLeft:Boolean = false;
	
	public function Hand(up:Boolean, right:Boolean, down:Boolean, left:Boolean) {
		hasUp = up;
		hasRight = right;
		hasDown = down;
		hasLeft = left;
	}
	//右回り。上の手をもつなら回転後は右の手をもつ。
	public function rotate():void {
		var temp:Hand = new Hand(false,false,false,false);
		if (hasUp) temp.hasRight = true;
		if (hasRight) temp.hasDown = true;
		if (hasDown) temp.hasLeft = true;
		if (hasLeft) temp.hasUp = true;
		hasUp = temp.hasUp;
		hasRight = temp.hasRight;
		hasDown = temp.hasDown;
		hasLeft = temp.hasLeft;
	}
}
