/**
 * Copyright purin ( http://wonderfl.net/user/purin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ZlX
 */

package {
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    
    public class FlashTest extends Sprite {
        private const BASE_Y:int = 180;
        private const MAX_RAYER:int = 2;
        private const MAX_ARRAY:int = 8;
        private var _bar:Array = [];
        
        public function init():void{
            graphics.beginFill(0xAAAAAA);
            graphics.drawRect(0, 0, 470, 180);
            graphics.drawRect(0, 280, 470, 190);
            graphics.endFill();
            
            barRender();
            
        }
        
        public function barRender():void{
             for(var i:int=0;i<MAX_ARRAY;i++){
                 _bar[i] = new Bar(0xFF0000 >> i * 8);
                 
                 if(i > 3)    _bar[i].px = i * 50;
                 else         _bar[i].px = i * 30;
                 
                 _bar[i].py = BASE_Y;
             }
             Resize();
             for(i=0;i<MAX_ARRAY;i++)    _bar[i].Render();   
        }        
        
        public function Resize():void{
			
			for(var i:int=0;i<MAX_ARRAY;i++){
				var endpoint:int = _bar[i].px+_bar[i]._width;
				 for(var k:int=i+1;k<MAX_ARRAY;k++){
				 	if(_bar[k].px >= endpoint){
				 		if(_bar[k]._flg == false){
							endpoint = _bar[k].px + _bar[k]._width;
					 		_bar[k]._rayercount = _bar[i]._rayercount;
					 		_bar[k].py = _bar[i].py;
					 		_bar[k]._flg = true;
					 	}
				 	}
				 	else{
				 		if(_bar[k]._flg == false){
				 			_bar[k]._rayercount++;
				 			_bar[k].py += _bar[i]._height;
				 		}
				 	}
				 }
			}

			for(i=0;i<MAX_ARRAY;i++)	_bar[i]._flg = false;
			
			//縮める幅の計算
			_bar[0]._crosscount = MAX_ARRAY;
			for(i=0;i<MAX_ARRAY;i++){
				endpoint = _bar[i].px+_bar[i]._width;
				for(k=i+1;k<MAX_ARRAY;k++){
					if(_bar[k]._flg)	break;
					if(_bar[k]._rayercount != _bar[i]._rayercount){
						if(_bar[k].px >= _bar[i].px && _bar[k].px <= endpoint){
							endpoint = _bar[k].px + _bar[k]._width;
							_bar[k]._crosscount = i+MAX_ARRAY;
							_bar[k]._flg = true;
						}
					}
					else{
						//同じレイヤーの帯がきたら次へ
						break;
					}
				}
			}
			
			for(i=0;i<MAX_ARRAY;i++){
				var count:int = 1;
				for(k=i+1;k<MAX_ARRAY;k++){
					if(_bar[k]._crosscount== i+MAX_ARRAY){
						count++;
					}
				}
				for(k=0;k<MAX_ARRAY;k++){
					if(_bar[k]._crosscount== i+MAX_ARRAY){
						if(i != k) _bar[k].py = _bar[i].py + _bar[i]._height;
						_bar[k]._height /= count;
					}
				}
			}
			
         }                   
        public function FlashTest():void{
            init();
            for(var i:int=0;i<MAX_ARRAY;i++)    addChild(_bar[i]._rect);
        }
 
    }
}

import flash.display.Sprite;

class Bar{
    
    public var _rect:Sprite;
    private var _color:int;
    public var _width:int;
    public var _height:int;
    public var px:int;
    public var py:int;
    
    public var _crosscount:int;
    public var _rayercount:int;
    
    public var _flg:Boolean;
    
    public function Bar(col:int):void{
        _rect = new Sprite();
        _color = col;
        
        _width = 100;
        _height = 100;
        _crosscount = 0;
        _rayercount = 0;	//縦の並び順
        _flg = false;		//位置決定フラグ
    }
    
    public function Render():void{        
        _rect.graphics.clear();
        _rect.graphics.beginFill(_color);
        _rect.graphics.drawRect(px,py,_width,_height);
        _rect.graphics.endFill();
    }

}
