/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9YQR
 */

/*
MultiLoader 0.3
BulkLoaderをお手本に0から書き直し。
主たる目的としてはBulkLoaderで作ったものを
wonderflで公開する時に
クラス名をMultiLoaderと書き換えるだけで
動くように作る、というもの。
なので、今の所必要最小限。

EventListenerまわりをちゃんと作り直したら、
だいぶ使い勝手がよくなるはず。今後の課題。
*/

package
{
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.LoaderContext;
    
    public class Main extends Sprite
    {
        private var multiLoader:MultiLoader;
        public function Main()
        {
            multiLoader = new MultiLoader("main");
            multiLoader.add("http://farm3.static.flickr.com/2499/3828917483_8948414d57_o.jpg",{context:new LoaderContext(true)});
            multiLoader.add("http://farm3.static.flickr.com/2664/3828917495_8e21ea52c1_o.jpg",{context:new LoaderContext(true)});
            multiLoader.add("http://farm4.static.flickr.com/3467/3828917519_d209a026fb_o.jpg",{context:new LoaderContext(true)});
            multiLoader.add("http://farm4.static.flickr.com/3542/3829716284_3f77a81e73_o.jpg",{context:new LoaderContext(true)});
            multiLoader.add("http://mztm.jp/wonderfl/3d/arss/data.xml");
            multiLoader.addEventListener(MultiLoader.COMPLETE, onCompleteHandler);
            multiLoader.start();
        }
        private function onCompleteHandler(event:Event):void{
            var n:int = multiLoader.itemsTotal;
            for (var i:int = 0; i < n; i++) {
                if(multiLoader.items[i].type == "image"){
                    var bitmap:Bitmap =  multiLoader.getBitmap(multiLoader.items[i].url.url);
                    bitmap.x = (i%2)*220; 
                    bitmap.y = Math.floor(i/2)*220;
                    this.addChild(bitmap);
                }else if(multiLoader.items[i].type == "text"){
                    trace(multiLoader.getText(multiLoader.items[i].url.url));
                    
                }
            }
        }
    }
}


/*
* Fileローダー
* */

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.system.Security;
import flash.utils.Dictionary;

class MultiLoader{
    public static var IMAGE_EXTENSIONS:Array = ["swf", "jpg", "jpeg", "gif", "png"];
    public static var TEXT_EXTENSIONS:Array = ["txt", "js", "xml", "php", "asp"];
    public static const COMPLETE:String = "complete";
    private var _listener:Function = function(event:Event):void{};
    private var _loads:Dictionary;
    private var _loadCount:int;
    private var _itemsLoaded:int;
    public var items:Array;
    public function MultiLoader(name:String){
        _loads = new Dictionary();
        _itemsLoaded = 0;
        items = [];
    }
    public function add(url:String,props:Object = null):void{
        var loadingItem:LoadingItem = new LoadingItem();
        loadingItem.url = new URLRequest(url);
        loadingItem.type = getType(url);
        if(props){
            if(props.context){
                loadingItem.context = props.context;
            }
        }
        items.push(loadingItem); 
    }
    private function getType(url:String):String{
        var i:int;
        var extension:String;
        var n:int = IMAGE_EXTENSIONS.length;
        var result:String = "";
        for (i = 0; i < n; i++) {
            extension = IMAGE_EXTENSIONS[i];
            if(extension == url.substr(-extension.length).toLowerCase()){
                result = "image";
                break;
            }
        }
        if(result == ""){
            n = TEXT_EXTENSIONS.length;
            for (i = 0; i < n; i++) {
                extension = TEXT_EXTENSIONS[i];
                if(extension == url.substr(-extension.length).toLowerCase()){
                    result = "text";
                    break;
                }
            }
        }
        return result;
    }
    
    public function start():void{
        var n:int = items.length;
        for (var i:int = 0; i < n; i++) {
            var type:String = items[i].type;
            if(type == "image"){
                _loads[items[i].url.url] = loadImage(items[i].url,items[i].context);
            }if(type == "text"){
                _loads[items[i].url.url] = loadText(items[i].url);
            }
            
        }
    }
    public function addEventListener(type:String,listener:Function):void{
        _listener = listener;
    }
    public function getBitmap(key:String):Bitmap{
        var bitmap:Bitmap = _loads[key].content;
        return bitmap;
    }
    public function getBitmapData(key:String):BitmapData{
        var bitmap:Bitmap = getBitmap(key);
        var bitmapData:BitmapData = new BitmapData(bitmap.width,bitmap.height);
        bitmapData.draw(bitmap);
        return bitmapData;
    }
    private function loadImage(url:URLRequest,context:LoaderContext = null):Loader {
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
        loader.load(url,context);
        return loader;
    }
    public function getText(key:String):String{
        return _loads[key].data;
    }
    private function loadText(url:URLRequest):URLLoader{
        var loader:URLLoader = new URLLoader();
        loader.addEventListener(Event.COMPLETE,onComp);
        loader.load(url);
        return loader;
    }
    private function onComp(event:Event):void{
        _itemsLoaded ++;
        if(_itemsLoaded == items.length){
            _listener(event);
        }
    }
    public function get itemsTotal():int{
        return items.length;
    }
    public function get itemsLoaded():int{
        return _itemsLoaded;
    }
    public function get loadedRatio():Number {
        return _itemsLoaded/items.length;
    }
}
class LoadingItem{
    public var url:URLRequest;
    public var type:String;
    public var status:String;
    public var context:LoaderContext;
    public function LoadingItem(){};
}