/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/9YM3
 */

// forked from Akiyah's グレートナビック風
package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.TextField;
    import flash.system.Security;
    import flash.geom.*;
    import com.actionsnippet.qbox.*;
    import Box2D.Common.Math.*;
    import net.hires.debug.Stats;

    [SWF (backgroundColor=0x000000, width=400, height=400)]
    public class FlashTest extends MovieClip {
        private var already:Boolean = false;

        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        private const path:String = "http://assets.wonderfl.net/images/related_images";
        private const filenames:Object = {
            "head": path + "/4/4c/4cb0/4cb05af46b3e48623a86d4082853b54962b3c867",
            "body": path + "/9/92/9227/922749a717f02a55a1ecb8bfceedad212976e8fd",
            "left_arm_a": path + "/a/a7/a70b/a70b7d3e4be386460a6208fca23f95d8f17015ca",
            "left_arm_b": path + "/1/1a/1ad9/1ad9644ad3302ad4a71bf97f156d32fd12ef06e4",
            "right_arm_a": path + "/2/21/2173/2173658f65ab1b8b4a22b76aa826315ae75d858d",
            "right_arm_b": path + "/1/12/12c9/12c93402c0d9095b83a63a368077b95f8a0b587c",
            "right_leg_a": path + "/6/69/69cf/69cf1c34145d77684e007cb4ad44ec114da9bb2c", 
            "right_leg_b": path + "/5/5e/5e97/5e97de035c05abb3d6f62e690fa3244a15464a24",
            "left_leg_a": path + "/f/fb/fb1d/fb1d38333e4dc25176e0c7037637f65d38c46571",
            "left_leg_b": path + "/5/5c/5ca1/5ca121ef79bac5caf39c3fb1bc9b9e43e1952e3f"
        };
        private var loaders:Object = {};

        public function FlashTest() {
            for (var key:String in filenames) {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
                loader.load(new URLRequest(filenames[key]), new LoaderContext(true));
                loaders[key] = loader;
            }
        }

        private function paste(obj:QuickObject, key:String):void {
            var loader:Loader = loaders[key];
            var w:Number = loader.width;
            var h:Number = loader.height;
            var bmd:BitmapData = new BitmapData(w, h, true, 0x000000);
            bmd.draw(loader);
            var g:Graphics = obj.userData.graphics;
            g.lineStyle(0, 0xff0000, 0);
            g.beginBitmapFill(bmd, new Matrix(1,0,0,1,-w/2,-h/2));
            g.drawRect(-w/2,-h/2,w,h);
        }

        public function compHandler(e:Event):void {
            if (already) {
                return;
            }
            for (var key:String in filenames) {
                var loader:Loader = loaders[key];
                if (loader.content == null) {
                    return;
                }
            }
            already = true;
            
            //addChild(new Stats());
            var sim:QuickBox2D = new QuickBox2D(this,{debug:false});

            sim.createStageWalls();
            sim.setDefault({lineAlpha:0, fillAlpha:0});

            var leftLegA:QuickObject = sim.addBox({x:4.5, y:9, width:1, height:1.75});
            var leftLegB:QuickObject = sim.addBox({x:4.5, y:10.5, width:1, height:2});
            var rightLegA:QuickObject = sim.addBox({x:5.5, y:9, width:1, height:1.75});
            var rightLegB:QuickObject = sim.addBox({x:5.5, y:10.5, width:1, height:2});

            var leftArmA:QuickObject = sim.addBox({x:3.6, y:5.8, width:1.6, height:0.75});
            var leftArmB:QuickObject = sim.addBox({x:2.5, y:5.8, width:1.6, height:0.75});

            var rightArmA:QuickObject = sim.addBox({x:6.4, y:5.8, width:1.6, height:0.75});

            var body:QuickObject = sim.addBox({x:5, y:7, width:2.5, height:2.5});
            var head:QuickObject = sim.addCircle({x:5, y:5, radius:0.8});

            var rightArmB:QuickObject = sim.addBox({x:7.8, y:5.8, width:2.5, height:1});
             
            paste(head, "head");
            paste(body, "body");
            paste(rightArmB, "right_arm_b");
            paste(rightArmA, "right_arm_a");
            paste(leftArmB, "left_arm_b");
            paste(leftArmA, "left_arm_a");

            paste(leftLegA, "left_leg_a");
            paste(leftLegB, "left_leg_b");
            paste(rightLegA, "right_leg_a");
            paste(rightLegB, "right_leg_b");
             
            var anchor:b2Vec2 = new b2Vec2();
            function connect(a:QuickObject, b:QuickObject, lower:Number, upper:Number, offX:Number=0, offY:Number = 0):QuickObject{
                 var min:Number = Math.min(a.y, b.y);
                 var max:Number = Math.max(a.y, b.y);
                 anchor.y = min + (max - min) * 0.5 + offY;
                 min = Math.min(a.x, b.x);
                 max = Math.max(a.x, b.x);
                 anchor.x = min + (max - min) * 0.5 + offX;
                return sim.addJoint({a:a.body, b:b.body, x1:anchor.x, y1:anchor.y, lowerAngle:lower, upperAngle:upper});
            }
             
            sim.setDefault({type:"revolute", collideConnected:false, enableLimit:true, lineColor:0xFFFFFF});
             
            connect(head, body, -.2, .2);
            connect(body, leftLegA, -1, 1, 0, -0.5);
            connect(leftLegA, leftLegB, -1, 1);
            connect(body, rightLegA, -1, 1, 0, -0.5);
            connect(rightLegA, rightLegB, -1, 1);
            connect(body, leftArmA, -2, 1);
            connect(leftArmA, leftArmB, -2, 1);
            connect(body, rightArmA, -1, 2)
            connect(rightArmA, rightArmB, -1, 2)

            sim.start();
            sim.mouseDrag();
        }
    }
}
