/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9XhD
 */

package
{
    import flash.display.*
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.ui.Mouse;
    import net.hires.debug.Stats;
    
    [SWF(frameRate="60", width="465", height="465")]


    /**
     * ...
     * @author nekome
     */    

    public class Main extends Sprite
    {
        private var blur:BlurFilter = new BlurFilter(3,3,2);
        private var src:BitmapData;
        private var cap:BitmapData;
        private var cap_sp:Sprite;     
        private var partList:Array = [];
        private var cnt:int=0;
        private var partBitmap:Bitmap;
        private var starBitmapData:BitmapData;
        private var _imgLoader:Loader;
        private var _imgLoaderInfo:LoaderInfo;

        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }            

        public function init(e:Event = null):void
        {
             removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            
            var url:String = "http://assets.wonderfl.net/images/related_images/f/f6/f639/f6398403089194595fa02a224ae008cc22d2bbd4";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext(true);
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq, context);
        }        

        private function onImageloaded(e:Event):void
        {    
            var bmd:BitmapData =  new BitmapData(_imgLoader.width, _imgLoader.height,true,0x00ffffff);
            bmd.draw(_imgLoader);
            starBitmapData = bmd.clone();            
            cap = new BitmapData(800, 600, true, 0x00ffffff)
            cap_sp = new Sprite();
            var dispBitmap:Bitmap = new Bitmap(cap);
            addChild(dispBitmap);
            this.addEventListener(Event.ENTER_FRAME, enterFrame);
            Mouse.hide();
            //addChild(new Stats);            
        }
        
        private function enterFrame(e:Event ):void {
            cnt++;
            if(cnt%1==0)createParticle();
            //cap.fillRect(new Rectangle(0,0,800,600),0x00ffffff);       
            cap.applyFilter(cap, cap.rect, new Point(0,0), blur);
            cap.draw(cap_sp);
            for (var i:int = 0; i < partList.length;i++ )
            {    
                var _part:MovieClip = partList[i];
                try {
                    _part.x += _part.vx *= .95;
                    _part.y += _part.vy *= .95;
                    _part.scaleX = _part.scaleY *= .9;                    
                    if (_part.scaleX < 0.05) {
                        cap_sp.removeChild(_part);
                        partList.splice(i,1);            
                    }
                }catch (error:Error) {
                    //trace('error='+error);
                }
            }
        }

        private function createParticle():void {
            var part:MovieClip = new MovieClip();
            partBitmap = new Bitmap(starBitmapData.clone());
            partBitmap.x = -partBitmap.width * 0.5;
            partBitmap.y = -partBitmap.height * 0.5;
            part.addChild(partBitmap);
            partList.push(part);
            cap_sp.addChild(part);
            part.blendMode =  BlendMode.LAYER;
            part.x = cap_sp.mouseX;
            part.y = cap_sp.mouseY;
            part.scaleX = part.scaleY = 1 + 2*Math.random();
            part.vx = (Math.random()*2-1)*10;
            part.vy = (Math.random()*2-1)*10;
        }
    }
}