/**
 * Copyright YAZUMA ( http://wonderfl.net/user/YAZUMA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9XYu
 */

package  {
    import flash.ui.Mouse;
    import flash.display.*;
    import flash.text.*;
 　 import fl.controls.*;
    import flash.utils.Timer;
    import flash.events.*;
    import com.bit101.components.InputText;
    import com.bit101.components.NumericStepper;
    [SWF(backgroundColor=0xffffff,width=600,height=600,frameRate=30)]

    public class Sample03 extends Sprite {
        private var timer:Timer = new Timer(100);
        private var l:Number = 1;
        private var T:Number = 0.3;
        private var sig:Number = 0.002;
        private var h:Number = 0.01;
        private var v:Number = Math.sqrt(T / sig);
        private var As:Number = 32 * h / (Math.PI * Math.PI * Math.PI);
        private var value:Array = [];
        private var s1:Sprite = new Sprite();
        public function Sample03() {
            s1.y = 300;
            var tf:TextField = new TextField();
            tf.width = 400;
            tf.defaultTextFormat = new TextFormat("メイリオ", 25, 0x0, true);
            tf.text = "弦の運動シミュレーション";
            addChild(tf);
            var tf2:TextField = new TextField();
            tf2.defaultTextFormat = new TextFormat("メイリオ", 15, 0x0, true);
            tf2.y = 40;
            tf2.width = 200;
            tf2.text = "弦の長さ[m]\n張力[N]\n綿密度[10^-3kg/m]\n初期変位[10^-2m]\n";
            addChild(tf2);
            var step1:NumericStepper = new NumericStepper(this, 165, 45, LENGTH);
            step1.value = 1;
            step1.minimum = 1;
            var step2:NumericStepper = new NumericStepper(this, 165, 70, FIX);
            step2.step = 0.1;
            step2.value = 0.3;
            step2.minimum = 0.1;
            var step3:NumericStepper = new NumericStepper(this, 165, 94, MI);
            step3.value = 2;
            step3.minimum = 1;
            var step4:NumericStepper = new NumericStepper(this, 165, 116, INI);
            step4.minimum = 1;
            step4.value = 1;
            timer.addEventListener(TimerEvent.TIMER, Location);
            timer.start();
        }
        private function INI(event:Event):void{
            var stepper:NumericStepper = event.currentTarget as NumericStepper;
            h = stepper.value / 100;
        }
        private function MI(event:Event):void{
            var stepper:NumericStepper = event.currentTarget as NumericStepper;
            sig = stepper.value / 1000;
        }
        private function FIX(event:Event):void{
            var stepper:NumericStepper = event.currentTarget as NumericStepper;
            T = stepper.value;
        }
        private function LENGTH(event:Event):void{
            var stepper:NumericStepper = event.currentTarget as NumericStepper;
            l = stepper.value;
        }
        private function Location(e:TimerEvent):void{
            var SIN:Array = [];
            var COS:Array = [];
            value = [];
            v = Math.sqrt(T / sig);
            As = 32 * h / (Math.PI * Math.PI * Math.PI);
            for(var i:int = 0;i < 10;i++){
                SIN = SIN_math(i * 0.1);
                COS = COS_math(i * 0.1);
                value[i] = 0;
                for(var j:int = 0; j < 3; j++){
                    var n:int = ((j + 1) * 2 - 1);
                    value[i] += As * SIN[j] * COS[j]　/ (n * n * n);
                }
            }
            s1.graphics.clear();
            Draw();
        }
        private function Draw():void{
            var X:Number = 50;
            
            for(var i:int = 0; i < 10; i++){
                X += (400 / 10);
                s1.graphics.lineStyle(6, 0x69b076);        
                s1.graphics.moveTo(X, value[i]*10000);
                s1.graphics.lineTo(X + 40, value[i+1]*10000);
                addChild(s1);
            }
        }
        private function SIN_math(_x:Number):Array{
            //sin項の演算
            var SIN:Array = [];
            for(var i:int = 0; i < 3; i++){
                SIN[i] = Math.sin(((i + 1) * 2 - 1) * Math.PI * _x / l);
            }
            return SIN;
        }
        private function COS_math(_x:Number):Array{
            //cos項の演算
            var COS:Array = [];
            var t:Number = 0.1 * timer.currentCount;
            for(var i:int = 0; i < 3; i++){
                COS[i] = Math.cos(((i + 1) * 2 - 1) * Math.PI * v * t / l);
            }
            return COS;
        }
    } 
}