/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9X4t
 */

package
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.primitives.Plane;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.core.Vertex;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    
    import flash.system.ApplicationDomain
    import flash.system.Security;
    import flash.system.LoaderContext;
    /**
     * TokyoTeraco11 その11
     * オリジナルのMeshを作成してみる
     * 三角形のプレーンを作ってみよう！
     * UVマップの設定
     *
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0
            cameraController.unbindAll()
            cameraController.lookAtXYZ(0, 0, 0)
            
            //1.メッシュ（Mesh）の作成
            var triangle:Mesh = new Mesh();
            
            //2.メッシュへ頂点（Vertex）の登録
            var MAX_VERTEX_NUM:uint = 3;
            var RADIAN:Number = Math.PI / 180;
            var radius:Number = 240;
            
            var vertices:Vector.<Vertex> = new Vector.<Vertex>(MAX_VERTEX_NUM);
            for (var i:int; i < MAX_VERTEX_NUM; i++ ) {
                var sx:Number = Math.cos((i * (360 / MAX_VERTEX_NUM)-90) * RADIAN) * radius;
                var sy:Number = Math.sin((i * (360 / MAX_VERTEX_NUM)-90) * RADIAN) * radius;
                vertices[i]=triangle.addVertex(sx, sy, 0, 0, 0, "vertex" + i);
            }
            
            //3.面（Face）の登録

            //表面
            triangle.addTriFace(vertices[0], vertices[1], vertices[2], null, 'face_front' + 0);
            
            //裏面
            triangle.addTriFace(vertices[0], vertices[2], vertices[1], null, 'face_back' + 0);
            
            //4.法線の計算
            triangle.calculateNormals();
            
            //6.テクスチャーへの対応（UV設定）
            
            //読み込むTextureの大きさ
            var tw:Number = 480
            var th:Number = 480
            
            //Vertexのx,yをu,vに変換
            //UV値は、テクスチャー画像の幅、高さをそれぞれ1とした時の比率
            for (i=0; i < MAX_VERTEX_NUM; i++ ) {
                vertices[i].u = (vertices[i].x + tw / 2) / tw;
                vertices[i].v = (vertices[i].y + th / 2) / th;
            }

         
            triangle.rotationX = -90 * RADIAN;
            
            container.addChild(triangle);
            

            //オブジェクトにマテリアルを設定
            var matArry:Vector.<TextureMaterial> = new Vector.<TextureMaterial>(1)
            var path:String = 'http://marubayashi.net/archive/sample/teraco/';
            matArry[0] = new TextureMaterial()
            matArry[0].diffuseMapURL = path + 'sunameri.jpg';
            
            var context :LoaderContext = new LoaderContext();
            Security.loadPolicyFile("http://marubayashi.net/crossdomain.xml");
            context.applicationDomain = ApplicationDomain.currentDomain;               
            
            
            //Textureに使用する画像を読み込む
            var materialLoader:MaterialLoader = new MaterialLoader()
            materialLoader.load(matArry);
            
            
            
            triangle.setMaterialToAllFaces(matArry[0]);
            

            
            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, triangle, 10);
            objectController.mouseSensitivity = 1
            objectController.unbindAll()
            
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame)

            
            
            
            function onEnterFrame(e:Event):void
            {
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }
                    
            
        }
        

        
    }
    
}
