/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9WKP
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.events.Event;
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#ffffff")]
    public class FlashTest extends Sprite {
        private var multiLoader:MultiLoader;
        private var assigneContainer:AssigneContainer;
        private var itemBtn:ItemBtn;
        private var itemURLArray:Array = ["http://assets.wonderfl.net/images/related_images/d/df/df7d/df7d681ee045b0a880a4e29b17dd89b49e8f29cc",// 服のボタンのURL
                                        "http://assets.wonderfl.net/images/related_images/8/8d/8db1/8db120b48c6cd0df2826666051dab32687bb0983",// キャラクターのURL
                                        "http://assets.wonderfl.net/images/related_images/8/87/87b1/87b1368ba52920859e04095126cf9194849f229f",// 服のベースのURL
                                        "http://assets.wonderfl.net/images/related_images/f/f4/f4b5/f4b57a28591168f37251205710e77fad2c4db7a6"]
        public function FlashTest() {
            multiLoader = new MultiLoader(itemURLArr);
            multiLoader.addEventListener(Event.COMPLETE, loadComplete);
            
            var itemBtnBmp:Bitmap = multiLoader.data.shift();
            var assigneBmpArr:Array = multiLoader.data;
            
            itemBtn = new ItemBtn(itemBtnBmp);
            addChild(itemBtn);
            itemBtn.x = (stage.stageWidth - itemBtn.width)/2;
            itemBtn.y = stage.stageHeight - itemBtn.height - 40;
            
            assigneContainer = new AssigneContainer(itemBtn, assigneBmpArr);
            addChild(assigneContainer);
            assigneContainer.x = (stage.stageWidth - assigneContainer.width)/2;
            assigneContainer.y = 80;            
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Loader;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class MultiLoader extends Loader
{
    private var _count:uint = 0;
    private var _urlArr:Array = [];
    private var _data:Array = [];
    public function MultiLoader(urlArr:Array):void
    {
        _urlArr = urlArr;
        dataLoad(_urlArr[_count]);
    }
    public function dataLoad(url:String):void
    {
        var context:LoaderContext = new LoaderContext(true);
        var _loader:Loader = new Loader();
        _loader.load(new URLRequest(url), context);
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
    }
    private function loadComplete(event:Event):void
    {
        event.currentTarget.removeEventListener(Event.COMPLETE, loadComplete);
        _data.push(event.currentTarget.content);
        
        _count++;
        if(_urlArr.length > _count) {
            dataLoad(_urlArr[_count]);
        } else if(_urlArr.length <= _count) {
            dispatchEvent(new Event(Event.COMPLETE));
        }
    }
    public function get data():Array{return _data;}
}

class AssigneContainer extends Sprite
{
    private var _itemBmp:Bitmap;
    public function AssigneContainer(call:Object, bmpArr:Array)
    {
        addChild(bmpArr[0]);
        
        addChild(bmpArr[1]);
        bmpArr[1].x = 38;
        bmpArr[1].y = 90;
        
        _itemBmp = bmpArr[2];
        addChild(_itemBmp);
        _itemBmp.x = 30;
        _itemBmp.y = 89;
        _itemBmp.visible = false;
        
        call.addEventListener("CLICK", assigne);
    }
    
    private function assigne(event:Event):void
    {
        if(_itemBmp.visible) {
            _itemBmp.visible = false;
        } else {
            _itemBmp.visible = true;
        }
    }
}

class ItemBtn extends Sprite
{
    public function ItemBtn(bmp:Bitmap)
    {
        addChild(bmp);
        
        buttonMode = true;
        addEventListener(MouseEvent.MOUSE_UP, clickAction)
    }
    private function clickAction(event:MouseEvent):void
    {
        dispatchEvent(new Event("CLICK"));
    }
}

