/**
 * Copyright peso ( http://wonderfl.net/user/peso )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9VcX
 */

package
{
    import flash.events.*;
    import flash.filters.*;
    import flash.utils.*;
    
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.*;
    
    public class week6_ex2 extends BasicView
    {
        private const N:int = 50;
        
        private var pixels:Pixels;
        
        public function week6_ex2()
        {
            var layer:BitmapEffectLayer = new BitmapEffectLayer(viewport, 640, 480);
            viewport.containerSprite.addLayer(layer);
            
            layer.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 4), false));
            
            pixels = new Pixels(layer);
            scene.addChild(pixels);
            
            for(var i:int=0; i < N; i++){
                
                var rad1:Number = (360 / N) * i * Math.PI / 180;
                
                for(var j:int=0; j < N; j++){
                    
                    var rad2:Number = ((180 / N) * j - 90) * Math.PI / 180;
                    var x:Number = 500 * Math.cos(rad2) * Math.sin(rad1);
                    var y:Number = 500 * Math.sin(rad2);
                    var z:Number = 500 * Math.cos(rad2) * Math.cos(rad1);
                    
                    pixels.addPixel3D(new Pixel3D(0xFF0000FF, x, y, z));
                }
            }
            
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            pixels.rotationX += 1;
            pixels.rotationY += 1;
            pixels.rotationZ += 1;
        }
    }
}