/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9U1L
 */

package {
    import __AS3__.vec.Vector;
    import flash.events.Event;
    import flash.filters.*;
    import frocessing.color.ColorHSV;
    import org.papervision3d.cameras.*;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.core.geom.renderables.Line3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    
    [SWF(backgroundColor=0xe1d4c7)]
    
    public class FlashTest extends BasicView {
        private var sphere:Sphere;
        private var line:Lines3D;
        private const A:Number = 10.0, B:Number = 25.0, C:Number = 8.0/3.0, D:Number=0.01;
        private var xx:Number, yy:Number, zz:Number;
        private var hsv:ColorHSV;
        private var glow:GlowFilter;
        private var particles:Vector.<Plane>;
        
        public function FlashTest() {
            super(465, 465, true, true, CameraType.SPRING);
            
            hsv=new ColorHSV(0,1,1);
            glow=new GlowFilter(0, 1, 8, 8, 2);
            particles = new Vector.<Plane>();
            xx = yy = zz = 1;
            
            sphere = new Sphere(new ColorMaterial(0xffffff), 3);
            sphere.x = sphere.y = sphere.z = 1;
            
            sphere.useOwnContainer = true;
            sphere.filters = [new BlurFilter(8,8,4), glow];
            camera.target = sphere;
            SpringCamera3D(camera).mass = 20;
            SpringCamera3D(camera).damping = 30;
            SpringCamera3D(camera).stiffness = 8;
            
            line = new Lines3D(null);
            scene.addChild(line);
            startRendering();
            
            addEventListener(Event.ENTER_FRAME, onFrame);            
        }
        
        private function onFrame(event:Event):void {
            var preX:Number = sphere.x;
            var preY:Number = sphere.y;
            var preZ:Number = sphere.z;
            
            var dx:Number, dy:Number, dz:Number;
            dx = A*(yy-xx);
            dy = xx*(B-zz)-yy;
            dz = xx*yy-C*zz;
            xx += D*dx;
            yy += D*dy;
            zz += D*dz;
            
            sphere.x = xx*2;
            sphere.y = yy*2;
            sphere.z = zz*2;
            
            line.addNewLine(2, preX, preY, preZ, sphere.x, sphere.y, sphere.z);
            var color:Number = Number(randomColor());
            glow.color = color;
            (line.lines[line.lines.length-1] as Line3D).material = new LineMaterial(color);
            hsv.h += 1;
        }
        private function randomColor():String {
            return '0x' + (Math.random()*200+55).toString(16)+(Math.random()*200+55).toString(16)+(Math.random()*200+55).toString(16);
        }


    }
}