/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9U0P
 */

/*
*    Zsort　の練習　↓参考
*    http://help.adobe.com/ja_JP/ActionScript/3.0_ProgrammingAS3/WS18334A17-3F85-4d5a-ADB4-F5BF6196774C.html
*/

package
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix3D;

[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)] 
	public class ExSort extends Sprite
	{
		private var _stg:Sprite;
		private var _list:Array = [];
		
		public function ExSort()
		{
			_stg = Sprite(addChild(new Sprite()));
			_stg.x = stage.stageWidth/2;
			_stg.y = stage.stageHeight/2;
			_stg.z = -50;
			
			init();
			
			addEventListener(Event.ENTER_FRAME,loop);
		}
		
		private function init():void
		{
			var f:Shape = new Shape();
			draw(f,0xff0000,0,0,50);
			
			var r:Shape = new Shape();
			draw(r,0x00ff00,50,0,0,0,90);
			
			var l:Shape = new Shape();
			draw(l,0x0000ff,-50,0,0,0,90);
			
			var b:Shape = new Shape();
			draw(b,0xffff000,0,0,-50);
			
			var t:Shape = new Shape();
			draw(t,0xff00ff,0,-50,0,90,0);
			
			var s:Shape = new Shape();
			draw(s,0x000000,0,50,0,90);
		}
		
		private function draw(target:Shape,color:uint,x:Number,y:Number,z:Number,rx:Number=0,ry:Number=0):void
		{
			_stg.addChild(target);
			_list.push(target);
			with(target.graphics)
			{
				beginFill(color);
				drawRect(-50,-50,100,100);
				endFill();
			}
			
			target.x = x;
			target.y = y;
			target.z = z;
			target.rotationX = rx;
			target.rotationY = ry;
		}
		
		private function loop(e:Event):void
		{
			_stg.rotationY += 1;
			_stg.rotationX += 1;
			sort();
		}
		
		private function sort():void
		{
			var i:uint;
			var zList:Array = [];
			
			for(i=0; i<_list.length; i++)
			{
				var mtx:Matrix3D = _list[i].transform.getRelativeMatrix3D(this);
         		        zList.push( { sp:_list[i], z:mtx.position.z } )
			}
			
		    zList.sortOn("z", Array.NUMERIC | Array.DESCENDING)
       		    for (i=0; i<_list.length; i++)
       		    {
          		_stg.setChildIndex(zList[i].sp, i)
          
      	 	    }
		}
	}
}
