/**
 * Copyright masamunet ( http://wonderfl.net/user/masamunet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9THE
 */

package {
    import flash.display.Sprite;
	import flash.display.Graphics;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var tf:TextField = new TextField;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.text = "ここに数字が表示されます。";
			addChild(tf);
			//直径
			var radius:Number = 10.0;
			//横の間隔
			var marginWidth:Number = 5.0;
			//縦の間隔
			var marginHeight:Number = 15.0;
			//ボタンの数
			var l:int = 5;
			for (var i:int = 0; i < l; i++) 
			{
				var sp:Sprite = createCircle(radius);
				sp.buttonMode = true;
				sp.x = ((sp.width + marginWidth) * i) + radius;
				sp.y = tf.height + marginHeight;
				addChild(sp);
				//このコードではどのボタンを押してもテキストフィールドには5が表示される
				sp.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
						tf.text = "このボタンナンバーは　" + i + "です。";
				});
			}
			//なぜならfor文を抜けたこの時点での変数iの中には5が入っているから。
			//（ボタンが押されてイベントリスナーが処理を始めるのは、時間的にみて
			//　このコードよりももっと後なので、その時の変数iを探しにいってしまう）
        }
		private function createCircle(radius:Number = 10.0, color:uint = 0xFF0000):Sprite {
			var sp:Sprite = new Sprite();
			var g:Graphics = sp.graphics;
			g.beginFill(color);
			g.drawCircle(0, 0, radius);
			g.endFill();
			return sp;
		}
    }
}