/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9SnU
 */

// forked from m0ose's flash on 2010-9-15
package {
    import flash.events.MouseEvent;
    import flash.display.AVM1Movie;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.utils.setTimeout
    
    /*
    RIPPLY WATER CELLULAR AUTOMATA
        cody smith
        m0ose.com
        
    algorithm by http://freespace.virgin.net/hugo.elias/graphics/x_water.htm
    
    */
    
    
    public class Fripples extends Sprite {
        
        public var loader:Loader;
        public var imgBMD:BitmapData;
        public var img:Bitmap;
        
        
        
        public var w:int=93;//width
        public var h:int=55;//height
        public var mult:int = 5;
        public var dampening:Number = 0.97;
            
        public var b0:Array=new Array(w);
        public var b1:Array=new Array(w);
        public var b2:Array = new Array(w);
          
        private var t:Timer;
        private var tRain:Timer;
        public var waterBMD:BitmapData;
        public var filt:DisplacementMapFilter;
        
        public function Fripples() {
            
          
            Wonderfl.capture_delay( 30 );
            loader = new Loader();
       
            var requestPic:URLRequest = new URLRequest();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, init);
            requestPic.url = "http://img828.imageshack.us/img828/9967/dsc01012nw.jpg";
            loader.load(requestPic, new LoaderContext(true));
        
            
        }
        
        public function init( e:Event):void
        {
            //image stuff
            //
            var bm:Bitmap = Bitmap( loader.content);
            imgBMD = bm.bitmapData;
            img = new Bitmap( imgBMD);
            addChild( img);
            
            waterBMD = new BitmapData( imgBMD.width, imgBMD.height, false);
            
            //
            // arrays
            //
                for( var x:int = 0; x < w; x++)
                {
                    b0[x] = new Array(h);
                    b1[x] = new Array(h);
                    b2[x] = new Array(h);    
                    for( var y:int=0; y< h;y++)
                    {
                        b0[x][y] = new Number();
                        b1[x][y] = new Number();
                        b2[x][y] = new Number();
                    }
                }//..init arrays
                
                t = new Timer( 20);
                t.addEventListener( TimerEvent.TIMER, run);
                t.start();
                
                // make it rain
                //tRain = new Timer(1000);
                //tRain.addEventListener( TimerEvent.TIMER, rain);
                //tRain.start();
                rain();
                
                stage.addEventListener( MouseEvent.MOUSE_MOVE, mouseWatch);
        
        }

        public function run(e:TimerEvent):void
        {
            for( var c:int = 0; c < 4; c++)
                {
                    for( var x:int = 1; x < w-1; x++)
                    {
                        for( var y:int=1; y< h-1;y++)
                        {
                            var v:Number = b1[x-1][y] + b1[x+1][y]
                                + b1[x][y-1] + b1[x][y+1];
                                //+ ( b1[x+1][y+1] + b1[x+1][y-1] + b1[x-1][y+1] + b1[x-1][y-1]) / 1.41 ;
                            v = (v / (4 ) ) - b2[x][y]; 
                            b0[x][y] = b1[x][y] + v;
                            b0[x][y] = b0[x][y] * dampening;
                        }//.. for x
                    }// .. for y
                
                    b2 = b1;
                    b1 = clone(b0);
                }// ..for c
                
                draw();
        }
        public function rain(e:TimerEvent = null):void
        {
            perturb( Math.random() * w* mult, Math.random() * h* mult);
            setTimeout( rain, Math.random() * 2000);
        }

        public function draw():void
        {
                for( var x:int = 0; x < w; x++)
                {
                    for( var y:int=0; y< h;y++)
                    {    
                        var r:Rectangle = new Rectangle( x*mult, y*mult, mult,mult);
                        waterBMD.fillRect( r, (  Math.round(b1[x][y])%256 + 128 ) * 0x010101 );
                    }
                }
                
                var blur:BlurFilter = new BlurFilter( 8,8,4);
                waterBMD.applyFilter( waterBMD, waterBMD.rect,new Point(), blur);
                
                initFilter()
                
        }
        public function initFilter():void
        {
            filt = new DisplacementMapFilter( waterBMD, new Point(0,0), 1,2, 300,300);
            img.filters = [filt];
            
        }
        public function perturb(x:int , y:int):void
        {
            if( b1 && x > 0 && y > 0 && x < w*mult && y < h*mult)
            {
                b1[Math.round(x/mult) ][ Math.round(y/mult) ] += 100;
            }

        }
        public function mouseWatch(e:MouseEvent):void
        {
            perturb( e.localX, e.localY);
        }





        public function clone( a:Array):Array
            {
                var b:Array = new Array( a.length);
                for( var x:int = 0; x < a.length; x++)
                {
                    b[x] = new Array( a[0].length );
                    for( var y:int=0; y< a[0].length;y++)
                    {
                        b[x][y] = new Number( a[x][y] );
                    }
                }
                return b;
            }

    }
}