/**
 * Copyright aasdb ( http://wonderfl.net/user/aasdb )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9SOt
 */

package {
    import frocessing.display.*;
    
    public class Kumo extends F5MovieClip2D {  
        public var w:Number = 450;
        public var h:Number = 450;
        private var N:int = 1300;
        private var palette:Array = new Array(255);
        private var particles:Array = new Array(N);
        
        public function setup():void {
            size(w,h);
            colorMode(HSB,255);
            fill(255);
            
            createPalette();
            createParticles();
        }
        
        public function draw():void{
            for(var i:int=0; i<h; i++){
                stroke(palette[int(map(i,0,h,0,255))]);
                line(0,i,w,i);
            }
            
            
            for(var j:int=0; j<N; j++){
                particles[j].draw();
                particles[j].move();
            }
        }
        
        private function createParticles():void{
            for(var i:int=0; i<N; i++){
                particles[i] = new Particle(this, random(w), random(h), random(100));
            }

        }

        
        private function createPalette():void{
            for(var i:int=0; i<255; i++){
                palette[i] = color((255-i)/20+140,255,255);
            }

        }
    }
}

import frocessing.display.*;
class Particle{
    private var g:F5MovieClip2D;
    private var x:Number;
    private var y:Number;
    private var s:int;
    
    public function Particle(_g:F5MovieClip2D, _x:int, _y:int, _s:int){
        g = _g;
        x = _x;
        y = _y;
        s = _s;
    }
    
    public function move():void{
        x += g.random(6);
        y += g.random(5) - 2;
        
        if(x<0) x = g.w;
        if(x>g.w) x = 0;
        if(y<0) y = g.h;
        if(y>g.h) y = 0;
    }
    
    public function draw():void{
        g.fill(255,15);
        g.noStroke();
        g.ellipse(x,y,s,s);
    }
}

