/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9SDx
 */

/*
 * スライダー
 * 上段：X軸を中心として回転
 * 中段：Y軸を中心として回転
 * 下段：Z軸を中心として回転
 * 左から根元、第１関節、第２関節、…で回転できます
 */
package {
	import flash.display.*;
	import flash.events.Event;
	import flash.geom.*;
	public class Main extends Sprite {
		
		private var SW:Number = stage.stageWidth;
		private var SH:Number = stage.stageHeight;
		private var borns:Array = new Array();
		
		public function Main():void {
			
			var bornsNum:uint = 8;
			var vArray:Array = ["x","y","z"];
			
			// Borns Setting
			for (var i:uint = 0; i < bornsNum; i++) {
				var born:Born = new Born();
				born.x = SW/2 + (i*50);
				born.y = SH/2;
				born.z = 0;
				addChild(born);
				borns.push(born);
			}
			
			// Controllers Setting
			for (var v:uint = 0; v < 3; v++) {
				for (var n:uint = 0; n < bornsNum; n++) {
					var sb:SlidBar = new SlidBar(borns.slice(n), vArray[v]);
					addChild(sb);
					sb.x = 20 + n * 45;
					sb.y = 70 + v * 130;
					sb.addEventListener(Event.CHANGE, xSlidBar);
					sb.blendMode = BlendMode.DARKEN;
				}
			}
		}
		
		public function xSlidBar(e:Event):void {
			
			var targets:Array = e.target.myTargets;
			var myAxis:String = e.target.myAxis;
			var axis:Vector3D;
			var val:Number = e.target.param / 10;
			var obj:Object = targets[0];
			var tv:Vector3D = new Vector3D(obj.x, obj.y, obj.z);
			if (myAxis == "x") {
				axis = Vector3D.X_AXIS;
			} else if (myAxis == "y") {
				axis = Vector3D.Y_AXIS;
			} else if (myAxis == "z") {
				axis = Vector3D.Z_AXIS;
			}
			for (var i:uint = 0; i < targets.length; i++) {
				obj = targets[i];
				obj.transform.matrix3D.appendTranslation(-tv.x, -tv.y, -tv.z);
				obj.transform.matrix3D.appendRotation(val, axis);
				obj.transform.matrix3D.appendTranslation( tv.x,  tv.y,  tv.z);
			}
		}
	}
}


import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.*;

class SlidBar extends Sprite {
	public var grab:Sprite;
	public var param:Number;
	public var myTargets:Array;
	public var myAxis:String;
	public function SlidBar(targets:Array, axis:String):void {
		myTargets = targets;
		myAxis = axis;
		grab = new Sprite();
		grab.graphics.lineStyle(2,0x666666);
		grab.graphics.beginFill(0xcccccc);
		grab.graphics.drawCircle(0,0,8);
		param = grab.y;
		addChild(grab);
		
		grab.addEventListener(MouseEvent.MOUSE_DOWN, mDown);
		grab.addEventListener(MouseEvent.MOUSE_UP,   mUp);
		
		graphics.lineStyle(2,0x666666);
		graphics.beginFill(0x999999);
		graphics.drawRoundRect(-10,-60,20,120,20);
	}
	private function mDown(e:MouseEvent):void {
		grab.startDrag(true, new Rectangle(0,-50,0,100));
		stage.addEventListener(Event.ENTER_FRAME, xLoop);
		stage.addEventListener(MouseEvent.MOUSE_UP, this.mUp);
	}
	public function mUp(e:MouseEvent):void {
		grab.stopDrag();
		stage.removeEventListener(Event.ENTER_FRAME, xLoop);
		grab.y = 0;
	}
	private function xLoop(e:Event):void {
		if (0 != grab.y) {
			param = grab.y;
			dispatchEvent(new Event(Event.CHANGE));
		}
	}
}

class Born extends Sprite {
	public function Born():void {
		graphics.beginFill(0x000033, 0.8);
		graphics.drawRoundRect(0,-10,50,20,20);
	}
}

