/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9S88
 */

// forked from chimanaco's textでマスク
/**
*  
*  ▼BitmapData を使って文字列でマスク
*  http://d.hatena.ne.jp/nitoyon/20070911/mask_letter
*  ▼扇形を作るクラス
*  ActionScript3.0入門ノート2
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.system.*;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	public class TextMask extends Sprite
	{
		private const STAGE_W:int = 465;
		private const STAGE_H:int = 465;
		private const WIDTH:int = 400;
		private const HEIGHT:int = 80;
		private var txt:TextField;
		private var tf:TextFormat;
		private var patt:BitmapData;
		private var rect1:Rectangle;
		private var rect2:Rectangle;
		private var base:Sprite;
		private var baseColor:Number = 0xFF8FC31F;
		private var circle:Sprite;
		private var pieSp:Sprite;
		private var pieNum:int;
		private var pieDeg:int = 12;
		private var pieR:Number = 500;
		private var pieColor:Number = 0x3139d5;
		private var bmpd:BitmapData;
		private var bmp:Bitmap;
		private var bmpdText:BitmapData;

		public function TextMask() {		
			// text
			tf = new TextFormat();
			tf.color = 0xFFFFFF;
			tf.font = "Arial Black";
			tf.align = "center";
			tf.size = 60;
			txt = new TextField();
			txt.defaultTextFormat = tf;
			txt.text = "Wonderfl!!!";
			txt.width = WIDTH;
			txt.height = HEIGHT;
			txt.background = true;
			txt.backgroundColor = 0;
			
			//pattern
			patt = new BitmapData(1, 10);
			rect1 = new Rectangle(0, 0, 1, 5);
			rect2 = new Rectangle(0, 5, 1, 5);
			patt.fillRect(rect1, 0xFF000000);
			patt.fillRect(rect2, baseColor);
			
			//base
			base = new Sprite();
			base.graphics.beginBitmapFill(patt, null, true, true);
			base.graphics.drawRect(0, 0, WIDTH, HEIGHT);
			base.graphics.endFill();
			
			//circle
			circle = new Sprite();
			base.addChild(circle);
			circle.x = STAGE_W / 2;
			
			//扇形
			pieNum = 360 / pieDeg;	
			for (var i:int = 0; i < pieNum; i++) {
				pieSp = new Pie(pieR / 2, i * pieDeg* 2,  pieDeg + i * pieDeg * 2, pieColor);	
				circle.addChild(pieSp);
			}
			
			// bitmap
			bmpd = new BitmapData(WIDTH, HEIGHT);
			bmp = new Bitmap(bmpd);
			bmp.y = STAGE_H/2 - HEIGHT/2;
			bmp.x = STAGE_W/2 - WIDTH/2;
			addChild(bmp);
			
			bmpdText = new BitmapData(WIDTH, HEIGHT, false);
			
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void {
			//rotaion
			circle.rotation += 5;
				
			// cache textField as BitmapData
			bmpdText.draw(txt);

			// mask
			bmpd.lock();
			bmpd.draw(base);
			bmpd.copyChannel(bmpdText, new Rectangle(0, 0, WIDTH, HEIGHT), new Point(0, 0), BitmapDataChannel.RED, BitmapDataChannel.ALPHA);
			bmpd.unlock();
		}
	}
}

import flash.display.Sprite;
import flash.geom.Point;

class Pie extends Sprite {
	private var radius:Number;
	private var deg0:Number, deg1:Number;
	private var fillColor:uint;
	
	public function Pie(r:uint, deg0:Number, deg1:Number, fillColor:uint) {
		this.radius = r;
		//start degree
		this.deg0 = deg0;
		//finish degree
		this.deg1 = deg1;
		this.fillColor = fillColor;
		drawFigrure();
	}
	
	private function drawFigrure():void {
		var pt:Point;
		var deg:int;
		
		var offset:Number = -90;
		graphics.beginFill(fillColor);
		
		graphics.moveTo(0, 0);
		for (deg = deg0; deg <= deg1; deg++) {
			var rad:Number = (deg + offset) * Math.PI / 180;
			pt = Point.polar(radius, rad);
			graphics.lineTo(pt.x, pt.y);
		}
		graphics.endFill();
	}
}