/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9RNf
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Matrix3D;
	import flash.geom.Utils3D;
	import flash.geom.Vector3D;
	import flash.utils.getTimer;
	
	public class Main extends Sprite 
	{
		
		private var vec2d:Vector.<Number> = new Vector.<Number>();
		private var vec2dOut:Vector.<Number> = new Vector.<Number>();
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			for (var i:int = 0; i < 100; i++) 
			{
				this.vec2d.push(
					Math.random() * 200 ,
					Math.random() * 200 ,
					Math.random() * 200 
				)
			}
			
			this.addEventListener(Event.ENTER_FRAME , this.onEnterFrame);
			
			
		}
		
		private function onEnterFrame(event:Event):void
		{
			var m:Matrix3D = new Matrix3D();
			m.appendTranslation(-100, -100, -100);
			m.appendRotation(getTimer() / 10 , Vector3D.X_AXIS);
			m.appendRotation(getTimer() / 15 , Vector3D.Y_AXIS);
			m.appendRotation(getTimer() / 20 , Vector3D.Z_AXIS);
			m.appendTranslation(200, 200, 0);
			Utils3D.projectVectors(m , this.vec2d , this.vec2dOut , new Vector.<Number>());
			
			this.graphics.clear();
			for (var i:int = 0; i < this.vec2dOut.length; i++) 
			{
				this.graphics.beginFill(0);
				this.graphics.drawCircle( this.vec2dOut[i++], this.vec2dOut[i], 1);
				this.graphics.endFill();
			}
		}
		
	}
	
}