/**
 * Copyright hacker_mx_95scj ( http://wonderfl.net/user/hacker_mx_95scj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9RHV
 */

// forked from sake's drawTrianglesをやってみた。
/*
   drawTrianglesの勉強中。
   ぐにょぐにょ動かしてみましたー！
   ちなみに画像はうちのにゃんこです。
 */

package
{
	import __AS3__.vec.Vector;
	import net.wonderfl.utils.SequentialLoader;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
	public class main extends Sprite
	{
		private const URL:String="http://assets.wonderfl.net/images/related_images/3/34/34d8/34d838651bde542d82b3a4f1b8675e57cd468bf9";
		private var bmpd:BitmapData;
		private var imgs:Array=[];

		private const NUM_X:int=20;
		private const NUM_Y:int=20;

		private var vertices:Vector.<Number>;
		private var indices:Vector.<int>;
		private var uvtData:Vector.<Number>;
		private var firstPointX:Vector.<Number>;
		private var firstPointY:Vector.<Number>;

		private var W:Number;
		private var H:Number;
		private var shape:Shape;

		public function main()
		{
			// 画像のロード
			SequentialLoader.loadImages([URL], imgs, onLoaded);
		}


		private function onLoaded():void
		{
			// 画像の読み込み
			var ldr:Loader=imgs.pop();
			bmpd=new BitmapData(ldr.width, ldr.height);
			bmpd.draw(ldr);

			W=bmpd.width;
			H=bmpd.height;

			shape=addChild(new Shape()) as Shape;
			shape.x=(465 - bmpd.width) / 2;
			shape.y=(465 - bmpd.height) / 2;

			uvtData=new Vector.<Number>();
			vertices=new Vector.<Number>();
			indices=new Vector.<int>();
			firstPointX=new Vector.<Number>();
			firstPointY=new Vector.<Number>();

			// 初期の座標を計算
			for (var i:int=0; i < NUM_X; i++)
			{
				for (var j:int=0; j < NUM_X; j++)
				{
					uvtData.push(j / (NUM_X - 1), i / (NUM_Y - 1));
					vertices.push(W * j / (NUM_X - 1), H * i / (NUM_Y - 1));
					firstPointX.push(W * j / (NUM_X - 1));
					firstPointY.push(H * i / (NUM_Y - 1));

					if (i != (NUM_Y - 1) && j != (NUM_X - 1))
					{
						indices.push(NUM_X * i + j, NUM_X * i + j + 1, NUM_X * (i + 1) + j);
						indices.push(NUM_X * i + j + 1, NUM_X * (i + 1) + j, NUM_X * (i + 1) + j + 1);
					}
				}
			}

			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		private function onFrame(e:Event):void
		{
			// 座標の計算
			for (var i:int=0; i < NUM_X * NUM_Y; i++)
			{
				var theta:Number=Math.atan2(vertices[i * 2 + 1] - shape.mouseY, vertices[i * 2] - shape.mouseX);
				var d:Number=300 / Math.sqrt(Math.pow(shape.mouseX - vertices[i * 2], 2) + Math.pow(shape.mouseY - vertices[i * 2 + 1], 2));

				vertices[i * 2]+=d * Math.cos(theta) + (firstPointX[i] - vertices[i * 2]) * 0.1;
				vertices[i * 2 + 1]+=d * Math.sin(theta) + (firstPointY[i] - vertices[i * 2 + 1]) * 0.1;
			}

			// draw！
			shape.graphics.clear();
			shape.graphics.beginBitmapFill(bmpd);
			shape.graphics.drawTriangles(vertices, indices, uvtData);
			shape.graphics.endFill();
		}
	}
}