/**
 * Copyright nagata_TDC ( http://wonderfl.net/user/nagata_TDC )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9QWi
 */

// forked from y_tti's 俺はそう考えてる


package
{
	import __AS3__.vec.Vector;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	import net.hires.debug.Stats;
	
	import funnel.*; 
	
	import org.papervision3d.objects.special.commands.LineStyle;
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	public class ytti_OrehaSouKangaeteru extends Sprite
	{
		private var _tfcanvas:BitmapData;
		private var _pts:Vector.<Point> = new Vector.<Point>();
		private var _linecanvas:BitmapData;
		private var _drawshape:Shape;
		private var _colorTran:ColorTransform = new ColorTransform(0.99,0.99,0.99,0.99);
		private var _blurFilter:BlurFilter = new BlurFilter(4,4,1);
		
        private var fioSystem:Fio;
        private var fio:IOModule;

        // 加速度センサのx軸を接続したアナログピン
        private var xAxisPin:Pin;

        // 加速度センサのy軸を接続したアナログピン
        private var yAxisPin:Pin; 
		
		public function ytti_OrehaSouKangaeteru()
		{
			addEventListener(Event.ADDED_TO_STAGE , _init );
			
            var config:Configuration = Fio.FIRMATA;

           // 必要ないアナログ入力をすべて出力にセットする
            // これによりデータの転送量が少なくなりレスポンスが良くなる
           // （ArduinoではA0、A1…はD14、D15に対応する）
            config.setDigitalPinMode(17, OUT);    // A3
            config.setDigitalPinMode(18, OUT);    // A4
            config.setDigitalPinMode(19, OUT);    // A5
            config.setDigitalPinMode(20, OUT);    // A6
            config.setDigitalPinMode(21, OUT);    // A7
            fioSystem = new Fio([1], config);
            fio = fioSystem.ioModule(1);

            xAxisPin = fio.analogPin(0);
           yAxisPin = fio.analogPin(1);

            // 2つの軸のそれぞれにフィルタをセット
            // ・細かな変動を取り除くための移動平均フィルタ
            // ・-1Gから1Gまでの変化を-1から1までにスケーリングするためのフィルタ
            xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            xAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            yAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1)); 
		}
		
		private function _init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE , _init );
			
			//TextField作成
			var oretf:Sprite = new OreTextField();
			
			//一時的にBitmapDataにdraw
			var mat:Matrix = new Matrix(1,0,0,1,(465-oretf.width)>>1,(465-oretf.height)>>1);
			var temp:BitmapData = new BitmapData(465,465,false,0x0);
			temp.draw(oretf,mat);
			
			//一定間隔でsetPixel32　＆　位置を保存
			_tfcanvas = new BitmapData(465,465,true,0x00FFFFFF);
			var margin:int = 4;
			for(var iy:int = 0;iy < _tfcanvas.height;iy=iy+margin ){
				for(var ix:int = 0;ix < _tfcanvas.width;ix=ix+margin ){
					if(temp.getPixel(ix,iy)) {
						_tfcanvas.setPixel32(ix,iy,0xFFFFFFFF);
						_pts.push(new Point(ix,iy));
					}
				}
			}
			//ライン用のBitmapData
			_linecanvas = new BitmapData(465,465,true,0x00FFFFFF);
			addChild(new Bitmap(_linecanvas));
			
			addChild(new Bitmap(_tfcanvas));
			
			//ライン作成用
			_drawshape = new Shape();
			
			addEventListener(Event.ENTER_FRAME , _update );
			addChild(new Stats());
		}
		
		private function _update(e:Event):void {
			//ラインクリア
			_drawshape.graphics.clear();
			
			_linecanvas.lock();
			for(var i:Number = 0;i < _pts.length;i++ ){
				//全部書くと重いので。。。。
				if(i%4 != 0) continue;
				
				//マウス位置からPixel位置の距離とか角度とか
				var dx:Number = - 2 * Math.asin(yAxisPin.value) / Math.PI * 180;; 
				var dy:Number = - 2 * Math.asin(xAxisPin.value) / Math.PI * 180;;
				var angle:Number = Math.atan2(dy,dx);
				var dist:Number = Math.sqrt(dx*dx + dy*dy);
				//ライン終点位置
				var tx:Number = _pts[i].x + Math.cos(angle) * dist;
				var ty:Number = _pts[i].y + Math.sin(angle) * dist;
				
				//ライン書く
				_drawshape.graphics.lineStyle(2);
				var mat:Matrix = new Matrix();
				mat.createGradientBox(465,465,angle);
				_drawshape.graphics.lineGradientStyle(
					GradientType.LINEAR,
					[0xFF00FF*Math.random(),
					0xFF00FF*Math.random()],
					[0.5,0],[0,255],mat
				);
				_drawshape.graphics.moveTo(_pts[i].x,_pts[i].y);
				_drawshape.graphics.lineTo(tx,ty);
			}
			_linecanvas.draw(_drawshape);
			_linecanvas.unlock();
			
			//フィルター
			_linecanvas.applyFilter(_linecanvas , _linecanvas.rect , new Point() , _blurFilter);
			_linecanvas.colorTransform(_linecanvas.rect , _colorTran );
		}
	}
}

import flash.text.TextField;
import flash.display.Sprite;
import flash.text.TextFormat;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormatAlign;

class OreTextField extends Sprite
{
	public function OreTextField(){
		var tf:TextField = new TextField();
		var fmt:TextFormat = new TextFormat("_ゴシック" , 56 , 0xFFFFFF );
		fmt.align = TextFormatAlign.CENTER;
		tf.defaultTextFormat = fmt;
		tf.autoSize = TextFieldAutoSize.LEFT;
		tf.multiline = true;
		
		addChild(tf);
		tf.text = "NAGATA\nHIROKAZU";
	}
}
