/**
 * Copyright genny ( http://wonderfl.net/user/genny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9QFF
 */

package {

	import flash.utils.Timer;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextLineMetrics;
	import flash.geom.Rectangle;
	
	
	public class Slider extends Sprite
	{
		
		/**
		*	property
		*/
		private var pointer:Sprite;
		private var base:Sprite;
		private var timer:Timer
		private var field:TextField;
		private var shokiX:int;
		private var maxX:int;
		
		
		/**
		*	constructer
		*/
		function Slider()
		{
			
			//----------------------------------
			//  ベースの生成
			//----------------------------------
			base = new Sprite();
			var basebase:Sprite = new Sprite();
			
			//	basebaseに矩形を描画
			basebase.graphics.beginFill( 0x333333 );
			basebase.graphics.drawRect( 0, 0, 300, 10 );
			basebase.graphics.endFill();
			
			//	基準点をセンターにしてbaseにAdd
			basebase.x = -basebase.width / 2;
			basebase.y = -basebase.height / 2;
			base.addChild( basebase );
			
			base.x = stage.stageWidth / 2;
			base.y = stage.stageHeight / 2;
			
			//	初期の座標を代入
			shokiX = base.x - base.width / 2;
			//	最大移動距離を代入
			maxX = base.x + base.width/2;
			
			trace( shokiX, maxX )
			
			addChild( base );
			
			
			//----------------------------------
			//  ポインタの生成
			//----------------------------------
			pointer = new Sprite();
			
			var tri:Sprite = new Sprite();
			tri.graphics.beginFill( 0x333333 );
			tri.graphics.lineTo( 0, 0 );
			tri.graphics.lineTo( 10, 0 );
			tri.graphics.lineTo( 5, 10 );
			tri.graphics.endFill();
			
			tri.x = -tri.width/2;
			tri.y = -tri.height;
			
			pointer.addChild( tri );
			
			//	初期位置設定
			pointer.x = base.x - base.width / 2;
			pointer.y = base.y - base.height / 2;
			pointer.buttonMode = true;
			pointer.useHandCursor = true;
			
			pointer.addEventListener( MouseEvent.MOUSE_DOWN, onStartDragHandler );
			
			addChild( pointer );
			
			
			//----------------------------------
			//  テキストフィールドの生成
			//----------------------------------
			field = new TextField();
			field.defaultTextFormat = new TextFormat("A-OTF ゴシックMB101 Pro M", 12, 0x333333);
			field.text = "VALUE：0";
			var metrics:TextLineMetrics = field.getLineMetrics( 0 );
			field.width = metrics.width + 30;
			addChild( field );

		}
		
		
		//----------------------------------
		//  ドラッグ開始メソッド
		//----------------------------------
		private function onStartDragHandler( event:MouseEvent ) :void
		{
			var mc:Sprite = event.currentTarget as Sprite;
			mc.removeEventListener( MouseEvent.MOUSE_DOWN, onStartDragHandler );
			stage.addEventListener( MouseEvent.MOUSE_UP, onStopDragHandler );
		
			mc.startDrag( false, new Rectangle( base.x - base.width / 2, base.y - base.height / 2, base.width, 0 ) );
			
			//	タイマーの開始
			timer = new Timer( 125 );
			timer.addEventListener( TimerEvent.TIMER, loop );
			timer.start();
			
		}
		
		
		//----------------------------------
		//  ドラッグ停止メソッド
		//----------------------------------
		private function onStopDragHandler( event:MouseEvent ) :void
		{
			pointer.addEventListener( MouseEvent.MOUSE_DOWN, onStartDragHandler );
			stage.removeEventListener( MouseEvent.MOUSE_UP, onStopDragHandler );
			pointer.stopDrag();
			
			//	タイマーの解除
			timer.stop();
			timer.removeEventListener( TimerEvent.TIMER, loop );

		}
		
		
		//----------------------------------
		//  ループ処理
		//----------------------------------
		private function loop( event:TimerEvent ) :void
		{
			field.text = "VALUE：" + String( slimitChange( pointer.x ) );
		}
		
		private function slimitChange( value:Number ) :Number
		{
			var result:Number;
			
			result = Math.round( 100 * ( value - shokiX ) / (maxX - shokiX) );
			return result;
		}
	}
}