/**
 * Copyright omari ( http://wonderfl.net/user/omari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Pnq
 */

// forked from moyashipan's 形態素解析もマルコフ連鎖もしないとこうなる
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.events.TextEvent;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.text.StyleSheet;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.ui.Keyboard;
    
    /**
     * 指定したTwitterIDの発言を取得して適当に並び替えます
     * 
     * TwitterIDを入力して[Search]を押してね
     * protectだったりすると見れないよ
     * reply先のIDをクリックするとその人の発言で生成するよ
     * 
     * http://apiwiki.twitter.com/Twitter-Search-API-Method%3A-search
     * @author Shinichiro Sugimoto
     */
    import flash.display.Graphics;
    public class Main extends Sprite 
    {
        private static const TWITTER_USER_LINK:String = '<a href="http://twitter.com/" target="_blank">http://twitter.com/$1</a>';
        private static const TWITTER_REPLY_LINK:String = '@<a href="event:$1" target="_blank">$1</a>';
        private static const TWITTER_SEARCH_INFO_URL:String = "http://search.twitter.com/search.atom?q=${q}";
        private static const SEARCH_PARAMS:Object = { rpp:20 };
        
        private var DEFAULT_USER_ID:String = "Moyashipan";
        
        private var textField:TextField;
        private var input:TextField;
        private var button:TextField;
        private var linkButton:TextField;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            var css:StyleSheet = new StyleSheet();
            css.setStyle("a", { color:"#2276BB", textDecoration:"underline" } );

            var g:Graphics = this.graphics;
            g.beginFill(0xe0ff92,1);
            g.drawRect(0, 0, 465, 30);
            g.endFill();
            g.beginFill(0x8ec1da,1);
            g.drawRect(0, 30, 465, 435);
            g.endFill();
            g.beginFill(0xffffff,0.8);
            g.drawRoundRect(5, 35, 455, 425, 10, 10);
            g.endFill();
            
            // INPUT ID
            input = new TextField();
            input.x = input.y = 5;
            input.width = 120;
            input.height = 20;
            input.border = true;
            input.borderColor = 0x999999;
            input.type = TextFieldType.INPUT;
            input.restrict = "[0-9a-zA-Z_]";
            input.text = DEFAULT_USER_ID;
            input.background = true;
            addChild(input);
            input.addEventListener(Event.CHANGE, onInputChange, false, 0, true);
            input.addEventListener(KeyboardEvent.KEY_UP, onKUp, false, 0, true);
            
            // SEARCH BUTTON
            button = new TextField();
            button.background = true;
            button.backgroundColor = 0x000000;
            button.textColor = 0xffffff;
            button.text = " Search";
            button.selectable = false;
            button.x = 127;
            button.y = 5;
            button.border = true;
            button.borderColor = 0x999999;
            button.width = 40;
            button.height = 20;
            addChild(button);
            button.addEventListener(MouseEvent.CLICK, onBClick, false, 0, true);
            
            // LINK
            linkButton = new TextField();
            linkButton.y = 5;
            linkButton.x = 170;
            linkButton.width = 230;
            linkButton.height = 20;
            linkButton.htmlText = getHtmlText();
            addChild(linkButton);
            linkButton.styleSheet = css;
            
            // RESULT
            textField = new TextField();
            textField.width = 465 - 10;
            textField.height = 465 - 40;
            textField.x = 5;
            textField.y = 35;
            textField.wordWrap = true;
            addChild(textField);
            textField.addEventListener(TextEvent.LINK, onReplyeeLink, false, 0, true);
            textField.styleSheet = css;
            
            //最初にすぐ表示
            onBClick();
        }
        
        private function onReplyeeLink(e:TextEvent):void 
        {
            input.text = e.text;
            linkButton.htmlText = getHtmlText();
            onBClick();
        }
        
        private function onKUp(e:KeyboardEvent):void 
        {
            if (e.keyCode == Keyboard.ENTER || e.keyCode == Keyboard.NUMPAD_ENTER) {
                onBClick();
            }
        }
        
        private function onInputChange(e:Event):void 
        {
            linkButton.htmlText = getHtmlText();
        }
        
        private function getHtmlText():String
        {
            return TWITTER_USER_LINK.replace(/\$1/g, input.text);
        }
        
        private function onBClick(e:* = null):void 
        {
            if (!button.mouseEnabled) return;
            
            button.mouseEnabled = false;
            button.textColor = 0x808080;
            
            if (input.text == "") input.text = DEFAULT_USER_ID;
            
            var twitterUrl:String = TWITTER_SEARCH_INFO_URL.replace("${q}", "from%3A"+ input.text);
            for (var key:String in SEARCH_PARAMS) {
                twitterUrl += "&" + key + "=" + SEARCH_PARAMS[key];
            }
            
            var loader:URLLoader = new URLLoader();
            var req:URLRequest = new URLRequest(twitterUrl);
            loader.addEventListener(Event.COMPLETE, onComplete, false, 0, true);
            loader.load(req);
        }
        
        private function onComplete(e:Event):void 
        {
            button.mouseEnabled = true;
            button.textColor = 0xffffff;
            
            var loader:URLLoader = e.target as URLLoader;
            
            if (loader != null && loader.data != null) {
                default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
                var xml:XML = new XML(loader.data);
                if (xml == null) {
                    showMessage("Not Found");
                    return;
                }
                if (xml.children().length() < 1) {
                    showMessage("Not Found\n\n" + xml.toString());
                    return;
                }
                
                var entries:XMLList = xml..entry;
                
                if (entries.length() < 1) {
                    showMessage("Not Found\n\n" + xml.toString());
                    return;
                }
                
                var word:String;
                
                var allArray:Array = [];
                for each(var entry:XML in entries) {
                    var title:XMLList = entry.title;
                    if (title == null) continue;
                    var array:Array = wordSplit(title[0].toString());
                    //for each(word in array) {
                        //if (allArray.indexOf(word) == -1) {
                            //allArray.push(word);
                        //}
                    //}
                    allArray = allArray.concat(array);
                }
                
                var resultStr:String = "";
                var i:uint = 0;
                var wordList:Array = ["の", "を", "と", "が", "に", "は", "の", "を、", "と", "が", "に", "は、", "です。\n", "！\n", "なの。\n", "？\n"];
                while (i < 100 && allArray.length > 0) {
                    var rand:uint = Math.floor(Math.random() * allArray.length);
                    word = allArray.splice(rand, 1);
                    var plusWord:String = wordList[Math.floor(Math.random() * 16)];
                    resultStr += word + plusWord;
                    i++;
                }
                
                textField.htmlText = resultStr + "！";
                return;
            }
        }
        
        private function showMessage(message:String):void
        {
            message = message.replace(/</g, "&lt;");
            message = message.replace(/>/g, "&gt;");
            textField.htmlText = message;
        }
        
        private function wordSplit(str:String):Array
        {
            var wordArray:Array = [];
            var urlPattern:RegExp = /(https?|ftp)(:\/\/[0-9a-zA-Z+$;?.%,!#~*\/:@&=_-]+)/gi;
            str = str.replace(urlPattern, ' ');
            
            //|\(|\)
            str = str.replace(/(の|を|と|が|に|は)+/g, ' ');
            str = str.replace(/( |　|\n|\r|\t|\.|,|"|'|、|。|？|!|！|\?|:|：|RT|>|<|「|」|『|』|\|)+/g, ' ');
            str = str.replace(/^( |　)+|( |　)+$/g, '');
            wordArray = str.split(" ");
            
            var word:String;
            for (var key:String in wordArray) {
                word = wordArray[key]
                if (word.charAt(0) != "@") continue;
                wordArray[key] = word.replace(/@([0-9a-zA-Z_]+)/g, TWITTER_REPLY_LINK);
            }
            
            return wordArray;
        }
        
    }
    
}