/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9PEg
 */

// forked from sinketu's waving font
package 
{
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.*;
    import flash.events.TimerEvent;
    import flash.filters.DropShadowFilter;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Timer;
    import net.hires.debug.Stats;
    /**
     * ... 
     * @author michiro
     */
    [SWF(backgroundColor="0xeeeeee", frameRate="30", width="465", height="465")]
    public class Main extends Sprite 
    {
        static public const WAVEPOINTS:uint=30;
        static public const W:uint=465;
        static public const H:uint= 465;
        private var myPointArray:Vector.<Number>=new Vector.<Number >();
        private var timerHolder:Vector.<Timer> = new Vector.<Timer>();
        private var setStringArray/*:String*/:Array = ["BRAD","SEDITO","[BRADSEDITO]","HELLO","WORLD "];
        private const SCROLL:uint = 1.2;
        private var myMask:Sprite;
        private var bg:Sprite;
        private var myTimerReset:Timer;
        private var arraytext:Array;
        private var setString:String;
        private var myText:TextField;
        private var myText2:TextField;
        private var Image2:Loader;
        private var Image1:Loader;
        
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
            Security.loadPolicyFile("http://www.sinketu.com/wonderfl/crossdomain.xml");
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //addChild(new Stats());
            
            //手を抜いちゃった。
            Image1 = new Loader();
            Image1.load(new URLRequest("http://seccombe2010.anat.org.au/files/2010/10/black-square1.jpg") );
            Image1.contentLoaderInfo.addEventListener(Event.COMPLETE, xComplete1);
        }
        private function xComplete1(e:Event):void 
        {
            Image1.contentLoaderInfo.removeEventListener(Event.COMPLETE, xComplete1);
            //手を抜いちゃった２。
            Image2 = new Loader();
            Image2.load(new URLRequest("http://www.sinketu.com/wonderfl/FT123_L.jpg"));
            Image2.contentLoaderInfo.addEventListener(Event.COMPLETE, setStage);
        }
        
        public function setStage(e:Event):void{
            //テキスト作成
            myText = TextClass.textPropertySet(200, 40,70, 0xFF0000, false, false,TextFieldAutoSize.LEFT,0,0,false,"Verdana",true);
            myText2 = TextClass.textPropertySet(200, 40,70, 0xFF0000, false, false,TextFieldAutoSize.LEFT,0,0,false,"Verdana",true);
            
            myText.text = myText2.text ="Sunlight";
            myText.y =myText2.y = (H - myText.textHeight) / 2;
            myText.x =myText2.x = (W - myText.textWidth) / 2;
            
            
            //背面（森）
            bg = new Sprite();
            addChild(bg);
            bg.addChild(Image1);
            bg.addChild(myText2);
            Image1.mask = myText2;
            Image1.cacheAsBitmap = true;//テキストにマスクをかけるコツ
            myText2.cacheAsBitmap = true;//テキストにマスクをかけるコツ
            
            //前面（水）
            var front:Sprite = new Sprite();
            addChild(front);
            front.addChild(Image2);
            front.addChild(myText);
            Image2.mask = myText;
            Image2.cacheAsBitmap = true;//テキストにマスクをかけるコツ
            myText.cacheAsBitmap = true;//テキストにマスクをかけるコツ
            
            var myDSFilter:DropShadowFilter = new DropShadowFilter(4, 4, 0x666666);
            bg.filters = [myDSFilter];
            front.filters = [myDSFilter];
            
            
            myMask = new Sprite();
            addChild(myMask);
            front.mask=myMask
            
            //myMask:Sprite　の中に波を作る。
            for (var i:uint = 0; i < WAVEPOINTS; i++ ) {
                myPointArray.push(0);
            }
            addEventListener(Event.ENTER_FRAME, xEnterFrame);
            
            //テキストの切り替え
            myTimerReset = new Timer(5000);
            myTimerReset.addEventListener(TimerEvent.TIMER, resetAnimation);
            setAnimation();
        }
        
        private function xEnterFrame(e:Event):void 
        {
            drawWave();
        }
        
        /**
         * 地道に波を描く
         */
        private function drawWave():void
        {
            myMask.graphics.clear();
            myMask.graphics.lineStyle(1, 0);
            myMask.graphics.beginFill(0xffeeee);
            myMask.graphics.moveTo(0,  W/2);
            var temp:Number;
            for (var i:uint = 0; i < myPointArray.length; i++ ) {
                myPointArray[i] += SCROLL;
                temp = Math.sin((myPointArray[i] + i) *10* Math.PI / 180)*10;
                myMask.graphics.lineTo((W*i) /( myPointArray.length-1),temp+ W/2+10);
            }
            myMask.graphics.lineTo(W,  W/2);
            myMask.graphics.lineTo(W, W);
            myMask.graphics.lineTo(0,  W);
            myMask.graphics.lineTo(0,  W/2);
        }
        
        /**
         * テキストアニメーション
         */
        private function setAnimation():void
        {
            arraytext = [];
            setString = setStringArray[Math.floor(Math.random() * setStringArray.length)];
            for (var i:uint = 0; i < setString.length; i++) {
                arraytext[i] = "";
            }
            //時間とともに動くモーションタイポ
            createAnimation();
            myTimerReset.start();
            
        }
        
        /**
         * テキストアニメーションの後片付けと再始動
         * @param    e
         */
        private function resetAnimation(e:TimerEvent):void
        {
            //timerを全部とめる。            
            for (var i:uint = 0; i < timerHolder.length; i++ ) {
                timerHolder[i].stop();
                timerHolder[i].removeEventListener(TimerEvent.TIMER, xRand);
                timerHolder[i].removeEventListener(TimerEvent.TIMER_COMPLETE,xFinish);
                timerHolder[i] = null;
            }
            timerHolder = new Vector.<Timer>();
            setAnimation();
        }
        
        /**
         * 文字をチャカチャカ動かす。
         */
        private function createAnimation():void
        {
            for (var i:uint = 0; i < setString.length ;i++ ){
                charAnimation(i)
            }
        }
        
        /**
         * 各文字ごとの文字の変更繰り返し
         * 
         * @param    num
         * @return
         */
        private function charAnimation(num:Number):void
        {
            var myTimer:Timer = new Timer(30, 50+num);
            myTimer.addEventListener(TimerEvent.TIMER, xRand(num));
            myTimer.addEventListener(TimerEvent.TIMER_COMPLETE,xFinish(num));
            myTimer.start();
            timerHolder.push(myTimer);
        }
        
        /**
         * myTimerの終了時に正しい文字をあてる。
         * 
         * @param    num
         * @return
         */
        private function xFinish(num:Number):Function
        {
            return function(e:TimerEvent):void 
            {
                trace(num);
                arraytext[num] = setString.charAt(num);
                setText();
                trace(arraytext);
            }
        }
        
        /**
         * 適当な文字を発生させる。
         * 
         * @param    num
         * @return
         */
        private function xRand(num:Number):Function
        {
            return function(e:TimerEvent):void 
            {
                var rand:uint = Math.floor(Math.random() * 94+33);
                var char:String = String.fromCharCode(rand);
                arraytext[num] = char;
                setText();
                trace(num,arraytext);
            }
        }
        
        /**
         * 作った文字を、指定の場所に割り当てる。
         */
        private function setText():void
        {
            myText.text = "";
            myText2.text = "";
            for (var i:uint = 0; i < arraytext.length; i++ ) {
                myText.appendText(arraytext[i]);
                myText2.appendText(arraytext[i]);
            }
        }
    }
}


import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
class TextClass
{
    public function TextClass() 
    {
        
    }
    /**
     * 
     * @param    w
     * @param    h
     * @param    size
     * @param    txtColr
     * @param    multi
     * @param    wrap
     * @param    auto
     * @param    space
     * @param    lead
     * @param    select
     * @param    font
     * @param    bold
     * @param    txttype
     * @param    b
     * @param    thick
     * @param    sharp
     * @param    kerning
     * @param    embed
     * @return
     */
    public static function textPropertySet(w:Number = 200, h:Number = 40, size:Number = 12 , txtColr:uint = 0x0, multi:Boolean = true, wrap:Boolean = true, 
    auto:String = TextFieldAutoSize.LEFT, 
    space:Number = 0, lead:Number = 0,
    select:Boolean = false, font:String = "Verdana",  bold:Boolean = false, 
    txttype:String = TextFieldType.DYNAMIC,
    b:Boolean = false, thick:Number = 1,
    sharp:Number = 1, kerning:Boolean = false, embed:Boolean = false ):TextField {
        var txt:TextField=new TextField;
        txt.width = w;
        txt.height = h;
        txt.selectable = select;
        txt.type= txttype;
        txt.thickness = thick;//（埋め込みフォント時のみ動作）
        txt.sharpness = sharp;//（埋め込みフォント時のみ動作）
        txt.border = b;
        txt.autoSize = auto;
        txt.multiline = multi;
        txt.wordWrap = wrap;
        txt.embedFonts = embed;//（埋め込みフォント時のみ動作）
        
        var myTextFormat:TextFormat = new TextFormat();
        myTextFormat.size = size;
        myTextFormat.font = font;
        myTextFormat.color = txtColr;// 文字の色
        myTextFormat.letterSpacing = space;// 文字間スペースの量(単位:ピクセル)
        myTextFormat.leading = lead;// 行間の垂直の行送り
        myTextFormat.bold = bold;// 太字にするか？
        myTextFormat.kerning = kerning;// カーニングが有効か？（埋め込みフォント時のみ動作）
        txt.defaultTextFormat = myTextFormat; 
        return txt;
    }
    
}

