/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Nfx
 */

// forked from bigfish's cellular automata bytearray
package {

  import flash.display.Sprite;
  import flash.utils.ByteArray;  
  import flash.text.TextField;
  import flash.text.TextFormat;

  public class Main extends Sprite{
	
	private var log:TextField = new TextField;

    public function Main(){
		log.multiline = true;
		log.width = 400;
		log.height = 600;
		log.type = "input";
		log.mouseWheelEnabled = true;
		var tf:TextFormat = new TextFormat();
	   	tf.font = "Verdana";
		log.defaultTextFormat = tf;
		addChild(log);

        var bytes:ByteArray = new ByteArray();
		//Boolean
		bytes.writeBoolean(true);
		log.appendText("bytes.writeBoolean(true)\n");
		showValue(bytes);
        //int
		bytes.length = 0;
        bytes.writeInt(1);//32 bit number = 4 bytes
        log.appendText("writeInt(1) \n");
		showValue(bytes);
		//uint
		bytes.length = 0;
        bytes.writeUnsignedInt(0xFFFFFF);//32 bit number = 4 bytes
        log.appendText("writeUnsignedInt(0xFFFFFF) \n");
		showValue(bytes);
		//byte - writes low 8 bits, values above 127 are ignored
		bytes.length = 0;
		log.appendText("writeByte(127) \n");
		bytes.writeByte(127);
		showValue(bytes);
		//while negative values are subtracted from 256
		bytes.length = 0;
		log.appendText("writeByte(-1) \n");
		bytes.writeByte(-1);
		showValue(bytes);
		//writeFloat
		bytes.length = 0;

		log.appendText("writeFloat(0xFFFFFFFFFFFFFFFF) \n");
		//value is too large - low 32 bits are taken
		bytes.writeFloat(0xFFFFFFFFFFFFFFFF);
		showValue(bytes);
		//try reading that double back
		//note it is really float  Number 
		bytes.position = 0;
		log.appendText("readFloat()="+bytes.readFloat()+"\n");
		//writeDouble
		bytes.length = 0;
		log.appendText("writeDouble(0xFFFFFFFFFFFFFFFF) \n");
		bytes.writeDouble(0xFFFFFFFFFFFFFFFF);
		showValue(bytes);
		//try reading that double back
		//note it is really truncated to a 32 bit Number when read
		bytes.position = 0;
		log.appendText("readDouble()="+bytes.readDouble() +"\n");
		//writeUTF
		bytes.length = 0;
		bytes.position = 0;
		log.appendText("bytes.writeUTF('è');\n");
		bytes.writeUTF("è");
		showValue(bytes);
		bytes.position = 0;
		log.appendText("readUTF()="+bytes.readUTF() +"\n");
		//writeUTF
		bytes.length = 0;
		bytes.position = 0;
		log.appendText("bytes.writeUTF('的');\n");
		bytes.writeUTF("的");
		showValue(bytes);
		bytes.position = 0;
		log.appendText("readUTF()="+bytes.readUTF() +"\n");
		showValue(bytes);//note that reading changes position
		//change value arbitrarily
		log.appendText("bytes[3] = 155\n");
		bytes[3] = 155;
		bytes.position = 0;
		log.appendText("readUTF()="+bytes.readUTF() +"\n");//get another character :)

	
    }
	private function showValue(bytes:ByteArray):void {
		log.appendText(" ----> value : [");
		for(var b:int = 0; b < bytes.length; b++) {
			log.appendText(bytes[b]);
			log.appendText((b < bytes.length - 1) ? ",": "");
		}	
		log.appendText("] size : " + bytes.length + ", ");
		log.appendText(" position : " + bytes.position + "\n");
		  
	  }

  }
}

