/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9NLb
 */

package {
    import com.bit101.components.TextArea;
    import flash.geom.Matrix;
    import flash.display.*;

    public class ReversingGradientBox extends TextArea {
		private static const N:Number = 1638.5; 

		private function trace(...args):void {
			text += args.join(" ") + "\n";
		}

		private function traceObj(msg:String, obj:Object):void {
			trace(msg);
			for(var p:String in obj) {
				trace("  " + p + ": " +  obj[p]);
			}
		}

		private function myGradientBox(w:Number, h:Number, rot:Number, tx:Number, ty:Number):Matrix {
			var mtx:Matrix = new Matrix;
			mtx.createBox(w/N, h/N, rot, tx+w/2, ty+h/2);
			return mtx;
		}

		private function len(x:Number, y:Number):Number { return Math.sqrt(x*x+y*y); }
		private function sign(x:Number):Number { return x < 0 ? -1 : 1; }

		private function mtxToBox(m:Matrix):Object {
			return {
				scaleX: len(m.a, m.c),
				scaleY: len(m.b, m.d),
				rotation: Math.atan2(m.b, m.d),
				tx: m.tx,
				ty: m.ty
			};
		}

		private function mtxToGradientBox(m:Matrix):Object {
			var w:Number = len(m.a, m.c)*N;
			var h:Number = len(m.b, m.d)*N;
			return {
				width: w,
				height: h,
				rotation: Math.atan2(m.b, m.d),
				tx: m.tx-w/2,
				ty: m.ty-h/2
			};
		}

		private function traceMtx(msg:String, mtx:Matrix):void {
			trace(msg);
			trace("  a:", mtx.a);
			trace("  b:", mtx.b);
			trace("  c:", mtx.c);
			trace("  d:", mtx.d);
			trace("  tx:", mtx.tx);
			trace("  ty:", mtx.ty);
		}

		private function testBoxDecomp(a:Number, b:Number, c:Number, d:Number, e:Number):void {	
			var mtx:Matrix = new Matrix;
			mtx.createBox(a,b,c,d,e);
			traceObj("Box decomposition: createBox("+a+", "+b+", "+c+", "+d+", "+e+") -> mtxToBox", mtxToBox(mtx));
			trace();
		}

		private function testGradientBoxDecomp(a:Number, b:Number, c:Number, d:Number, e:Number):void {	
			var mtx:Matrix = new Matrix;
			mtx.createGradientBox(a,b,c,d,e);
			traceObj("GradientBox decomposition: createGradientBox("+a+", "+b+", "+c+", "+d+", "+e+") -> mtxToGradientBox", mtxToGradientBox(mtx));
			trace();
		}

        public function ReversingGradientBox() {
			width = height = 465;
			var mtx:Matrix = new Matrix;

			trace("AS3 createGradientBox clone:");
			traceMtx("myGradientBox(1, 2, 3, 4, 5): ", myGradientBox(1, 2, 3, 4, 5));
			mtx.createGradientBox(1, 2, 3, 4, 5);
			traceMtx("createGradientBox(1, 2, 3, 4, 5): ", mtx);
			trace();

			testBoxDecomp(1, 2, 3, 4, 5);
			testBoxDecomp(1, 2, -3, -4, -5);

			testGradientBoxDecomp(1, 2, 3, 4, 5);
			testGradientBoxDecomp(1, 2, -3, -4, -5);
		}
	}
}
			
