/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9MRM
 */

// forked from narutohyper's forked from: nengaflでブロック崩し・・・風
// forked from nengafl's nengafl
/*nengaflでブロック崩し風*/
package { 
	import flash.text.TextFormat; 
	import flash.text.TextField; 
	import flash.text.TextFieldAutoSize
	import flash.display.Sprite; 
	import flash.events.Event;

	[SWF(width = 465, height = 465, frameRate = 60)]

	/**
	 * Nengaflをそのまま使って、さくっと遊んでみました。
	 * ブロック崩し風（ベースとして作ってますので、あくまで雰囲気だけ）です。
	 * もう少し当たり判定とかを厳格にしたり、コントローラーを操作できるようにしたりすれば、そのままゲームになる？かもです
	 * 
	 * テキストをパーティクル化してますので、
	 * 改良すれば、インベーダーゲームなんかもつくれちゃいますよ
	 * 
	 * @narutohyper
	 */

	public class Nengafl extends Sprite { 

		public var counter:uint=0;
								 
		public function Nengafl() { 
			/* 
				これからActionScript3.0を始める人が、あなたの作品を通してFlashの楽しさを知り 
				ASの世界に足を踏み入れるきっかけになるような課題作品をつくってください！ 

				一番FORKされた方に、wonderflからお年玉、なんと現金10万円を贈呈します！	

			 単純に数字を変えるだけで、面白い動きがでるのもOK!	
			 真面目な課題ももちろんOK! 
			「面白いAS 」の定義はみなさんにおまかせします！ 
			 Flash仲間が増え、Flash界が盛り上がるような作品の応募をお待ちしております。 
			*/
			var nengaText:String = "<font color='#FF0000'><b>これからActionScript3.0を始める人が、あなたの作品を通してFlashの楽しさを知り<br>" +	
				"ASの世界に足を踏み入れるきっかけになるような課題作品をつくってください！<br>　<br>" + 
				"一番FORKされた方に、wonderflからお年玉、なんと現金10万円を贈呈します！<br>　<br>" + 
				"単純に数字を変えるだけで、面白い動きがでるのもOK!<br>" + 
				"真面目な課題ももちろんOK!<br>" + 
				"「面白いAS」の定義はみなさんにおまかせします！<br>" + 
				"Flash仲間が増え、Flash界が盛り上がるような作品の応募をお待ちしております。</b></font>";	
				
			var format:TextFormat = new TextFormat(); 
			format.size = 26; 
			format.color = 0xFF0000; 

			var nengaTextBox:TextField = new TextField(); 
			nengaTextBox.width=400;
			nengaTextBox.height=400;
			nengaTextBox.x=35;
			nengaTextBox.y=100;

			nengaTextBox.multiline = true;	
			nengaTextBox.wordWrap = true;  
			nengaTextBox.defaultTextFormat = format; 
			nengaTextBox.htmlText = nengaText; 


			/*
			弾を作る
			*/
			var bullet:Bullet=new Bullet(this)

			//bullet.x=0
			bullet.y=400


			/*
			バーを作る
			*/
			var bar:Bar=new Bar(this,bullet)
			bar.x=200
			bar.y=450

			/*
			テキストをパーティクルに変換
			*/
			var counterMax:uint=0;

			var str:Array=[]
			var row:uint=0
			str[row]=[];


			for(var i:uint=0;i<nengaTextBox.text.length;i++) {
				if (nengaTextBox.text.charCodeAt(i)<=32) {
					row++;
					str[row]=[];
				} else {
					str[row].push(new Particle(this,nengaTextBox.text.charAt(i),bullet));
					counter++
				}
			}
			counterMax=counter

			nengaTextBox.htmlText = 'あけまして、おめでとうございます。<br>'+
			'今年もよろしくお願いします。';

			/*
			テキストパーティクルを、通常テキストと同じように配置
			*/
			var nextX:Number=10;
			var nextY:Number=40;
			for(i=0;i<str.length;i++) {
				for(var n:uint=0;n<str[i].length;n++) {
					str[i][n].x=nextX;
					str[i][n].y=nextY;
					this.addChild(str[i][n]);
					nextX+=(str[i][n].width-0.7);
				}
				nextX=10;
				nextY+=16;
								
			}


			/*
			カウンター表示用のテキストfieldを作る
			*/
			var counterBox:TextField=new TextField()
			counterBox.autoSize=TextFieldAutoSize.LEFT
			counterBox.selectable=false;
			counterBox.mouseEnabled=false;

			format.color=0x666666
			format.size=12;
			format.font='_ゴシック';
			counterBox.defaultTextFormat=format
			this.addChild(counterBox);


			/*
			スタート！
			*/
			bullet.start();
			bar.start();

			this.addEventListener(Event.ENTER_FRAME,onEnterFrame)

			var me:Nengafl=this;

			function onEnterFrame(e:Event=null):void {
				counterBox.text = counter+"/"+counterMax;

				if(counter<=0) {
					me.addChild(nengaTextBox);
					me.removeEventListener(Event.ENTER_FRAME,onEnterFrame)
					bullet.stop();
					bar.stop();
				}
			}

		}



	}
}


import flash.display.DisplayObjectContainer
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;

import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

import flash.events.Event;


/*
テキストパーティクル
*/

class Particle extends Sprite {
	private var parentMc:*;
	private var str:String;
	private var bullet:Bullet

	public function Particle(_parentMc:*,_str:String,_bullet:Bullet) {
		

		parentMc = _parentMc;
		str = _str;
		bullet = _bullet;

		var tf:TextField=new TextField()
		tf.autoSize=TextFieldAutoSize.LEFT
		var format:TextFormat=new TextFormat();
		format.color=0xFF0000
		format.size=12;
		format.bold=true;
		format.font='_ゴシック';
		tf.defaultTextFormat=format;
		tf.text=str;
		tf.x=-1
		
		var tempSprite:Sprite=new Sprite();
		tempSprite.addChild(tf)
		var bt:BitmapData=new BitmapData(tempSprite.width-3,tempSprite.height,true,0x00000000);
		//めんどくさいからdraw。高速化するなら、copyPixelで。
		bt.draw(tempSprite);
		var bm:Bitmap=new Bitmap(bt,PixelSnapping.NEVER);
		this.addChild(bm);

		this.addEventListener(Event.ENTER_FRAME,onEnterFrame)
	}

	public function get text():String {
		return str;
	}

	public function onEnterFrame(e:Event=null):void {
		if (this.hitTestObject(bullet)) {
			this.removeEventListener(Event.ENTER_FRAME,onEnterFrame);
			parentMc.removeChild(this)
			bullet.reverse()
			parentMc.counter--;
		}
	}

}




/*
Bar
*/

class Bar extends Sprite {

	private var parentMc:DisplayObjectContainer;
	private var bullet:Bullet

	public function Bar(_parentMc:DisplayObjectContainer,_bullet:Bullet) {
		parentMc=_parentMc;
		bullet=_bullet;

		parentMc.addChild(this);

		var tempSprite:Sprite=new Sprite();

		//Barの絵を描く
		tempSprite.graphics.beginFill(0x006600,1)
		tempSprite.graphics.drawRect(0,0,40,10)

		//シェイプのままだと、動きがもっさりするので、Bitmap化しておく
		var bt:BitmapData=new BitmapData(tempSprite.width,tempSprite.height,true,0x00000000);
		bt.draw(tempSprite);
		var bm:Bitmap=new Bitmap(bt,PixelSnapping.AUTO);
		this.addChild(bm);
		bm.x=-20
		
	}

	public function start():void {
		this.addEventListener(Event.ENTER_FRAME,onEnterFrame)
	}

	public function stop():void {
		this.removeEventListener(Event.ENTER_FRAME,onEnterFrame)
	}


	public function onEnterFrame(e:Event=null):void {
		if (this.hitTestObject(bullet)) {
			bullet.reverse()
			bullet.speedUp()
		}

		this.x=bullet.x

	}

}








/*
弾
*/
class Bullet extends Sprite {

	private var parentMc:DisplayObjectContainer;
	private var pitchX:Number=2;
	private var pitchY:Number=3;

	private var wayX:Number=1;
	private var wayY:Number=-1;
	private var reverseFlag:Boolean=false;

	public function Bullet(_parentMc:DisplayObjectContainer) {
		parentMc=_parentMc;

		parentMc.addChild(this);

		var tempSprite:Sprite=new Sprite();

		//弾の絵を描く
		tempSprite.graphics.beginFill(0x0000FF,1)
		tempSprite.graphics.drawRect(0,0,10,10)

		//シェイプのままだと、動きがもっさりするので、Bitmap化しておく
		var bt:BitmapData=new BitmapData(tempSprite.width,tempSprite.height,true,0x00000000);
		bt.draw(tempSprite);
		this.addChild(new Bitmap(bt,PixelSnapping.AUTO));
		

	}

	public function start():void {
		this.addEventListener(Event.ENTER_FRAME,onEnterFrame)
	}

	public function stop():void {
		this.removeEventListener(Event.ENTER_FRAME,onEnterFrame)
	}

	
	public function onEnterFrame(e:Event=null):void {
		if (reverseFlag) {
			wayY*=-1
			reverseFlag=false
		}

		this.x+=pitchX*wayX
		this.y+=pitchY*wayY

		if (this.x+this.width>parentMc.stage.stageWidth) {
			wayX*=-1
		} else if (this.x<0) {
			wayX*=-1
		}

		if (this.y+this.height>parentMc.stage.stageHeight) {
			wayY*=-1
		} else if (this.y<0) {
			wayY*=-1
		}


	}

	public function reverse():void {
		reverseFlag=true;
	}

	public function speedUp():void {
		pitchX+=0.1
		pitchY+=0.1
	}



}


