/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9MIw
 */

package {

    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;;
    import flash.utils.*;
    
    import flash.text.*;
    public class Main extends Sprite{

        private const ZEROS:Point = new Point();
        private var txt1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        
        private var _mic:Microphone;//マイクキャプチャ

        private var _records:Vector.<Number>;

        private var _sound:Sound;
        private var _soundChannel:SoundChannel;//サウンド制御
        private var _position:int;
        private var pos2:int;
        private var pos3:int=0;

        private var _canvas:BitmapData;
        private var _slit:BitmapData;
        
        private var hz:int = 4410;
        private var text1:TextField = new TextField();
        private var color:uint = 0x00ff0000;
        
        private var cnt:int =0;
        private var cnt2:int =0;
        
        public function Main():void {
            //マイクキャプチャの設定
            _mic = Microphone.getMicrophone();//マイクデバイス使用許可の要求
            //_mic.setLoopBack(true);//スピーカーへフィードする
            _mic.rate = 44;//キャプチャレート指定
            _mic.setSilenceLevel(0);//検出レベル
            _mic.setUseEchoSuppression(true);//エコー抑制機能
            txt1.text= _mic.name;
            txt1.type ="input";
            txt2.width =400;
            text1.y = 40;
            text1.width = 400;
            text1.text=String(hz);
            //txt1.type ="dynamic";
            _sound = new Sound();
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff);
            _slit = new BitmapData(1, stage.stageHeight, false, 0xffffff);
            addChild( new Bitmap(_canvas) );
            addChild(txt1);
            txt2.y=20;
            addChild(txt2);
            addChild(text1);
            
            _records = new Vector.<Number>(441000);
            
            
            _startRecord();// 01
            _startSound();

        }

        //　01
        private function _startRecord():void {
            _position = 0;
            _mic.addEventListener(SampleDataEvent.SAMPLE_DATA, _micSampleDataHandler);// 02
        }
        
        
        //　02
        private function _micSampleDataHandler(e:SampleDataEvent):void
        {
            var sw:int = stage.stageWidth;//描画高さ
            var sh:int = stage.stageHeight;//描画幅
            
            var datas:ByteArray = e.data;           
            
            
            //txt2.text = String(_position); 
            
            txt1.text = String(datas.bytesAvailable);
            
            
            
            while (datas.bytesAvailable)//読み取り可能なバイト数
            {
                var data:Number = _records[_position] = datas.readFloat();
        
                
                //波形描画
                if (_position % 3 == 0)
                {
                    var x:Number = _position / _records.length * sw;
                    var y:Number = sh * 0.5 - data * 1000;             
                    _canvas.copyPixels(_slit, _slit.rect, new Point(x + 1, 0))
                    _canvas.setPixel(x, y, color);//描画     
                }
                
                
                //マイクキャプチャ終了　→　再生開始
                if (++_position == _records.length)//ポジションが終わりまできたら
                {
                    _position =0;
                    //マイクキャプチャ終了
                    //_mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, _micSampleDataHandler);// 02
                    //再生開始
                    //_startSound();// 03
                    //_startRecord()
                    
                    return;
                    
                }
            }
        }
        
       
        // 03 再生開始
        private function _startSound():void
        {
            //pos2 = 0;//ポジションリセット
            //サウンドデータの要求イベント
            _sound.addEventListener(SampleDataEvent.SAMPLE_DATA, _soundSampleDataHandler);
            
            _soundChannel = _sound.play();
        }
        
        // 04 サウンドデータ要求
        private function _soundSampleDataHandler(e:SampleDataEvent):void
        {
            
            txt2.text = "pos2:"+String(pos2); 
            txt2.appendText(" length:"+String(_records.length));
            //サンプル数2048　～　8192 の間で指定
            for (var i:int = 0; i < 8192; ++i)
            {
                
                var data:Number = _records[pos2];
                
                
                //オーディオストリーム内のデータへ32bit浮動小数点数の書き込み
                e.data.writeFloat(data);// 左スピーカ
                //e.data.writeFloat((Math.random()-0.5)*0.003);
                　
                //e.data.writeFloat((Math.random()-0.5)*0.01);　
                //e.data.writeFloat(0);
                e.data.writeFloat(data);// 右スピーカ
                
             
                //再生終了　→　マイクキャプチャ開始
                pos2++;
                pos2%=_records.length;
   
            }//for()
            //e.position = 0;
            text1.text = "e.pos:"+String(e.position);
            
            //_sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _soundSampleDataHandler);// 04
            if (pos2 >= _records.length)
            {
                
                //pos2 = 0;//データロード位置リセット
                _sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _soundSampleDataHandler);// 04
                //_startRecord();// 01
                //_startSound();
                return;
            }
            
            
        }//_soundSampleDataHandler()
    }


}