/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9MC5
 */

// forked from oreore's ParticleMaterialの回転でサイクロン
package  
{
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	
	//papervision3D
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.materials.special.ParticleMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.special.ParticleField;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	
	//Tweener
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.ColorShortcuts;
	import caurina.transitions.properties.FilterShortcuts;
	import caurina.transitions.properties.CurveModifiers;
	
	/**
	 * ...
	 * @author oreore
	 */
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	public class Main extends Sprite
	{
		private var _world:DisplayObject3D;
		private var particles:ParticleField;
		private var bel:BitmapEffectLayer;
		private var basicBiew:BasicView;
		private var timer:Timer;
		
		public function Main() 
		{
			init();
		}
		
		private function init():void
		{
			
			basicBiew = new BasicView();
			addChild(basicBiew);
			_world = new DisplayObject3D();
			basicBiew.scene.addChild(_world);
			basicBiew.startRendering();
			
			//--------------------------------------------------------------------------
			//  オブジェクトの作成
			//--------------------------------------------------------------------------
			var mat:ParticleMaterial = new ParticleMaterial(0xffffff,1,1); 
			////pf = new ParticleField(mf, 1000, 5, 1000, 1000, 1000);
			particles = new ParticleField(mat, 2000, 4);
			//Displayにパーティクルを設置する。
			_world.addChild(particles);
			
			
			//--------------------------------------------------------------------------
			//  bitmapfillter
			//　　ColorTransformでうまく軌跡が消せない
			//　　blurを使うと消えてくれるけど描画面積が大きくなると重くなる。。。。
			//--------------------------------------------------------------------------
			
			
			//new BitmapEffectLayer(viewport,幅,高さ,透過,色,BitmapClearMode);
			bel = new BitmapEffectLayer(basicBiew.viewport, stage.stageWidth, stage.stageHeight, true, 0x00000000, BitmapClearMode.CLEAR_PRE,false,false);
			
			
			//http://hakuhin.hp.infoseek.co.jp/main/as/blend.html フィルターみたいなもの
			bel.drawCommand.blendMode = BlendMode.ADD;
			
			bel.drawCommand.colorTransform = new ColorTransform(.1, .3, .8, .1);
			basicBiew.viewport.containerSprite.addLayer(bel);
			bel.addDisplayObject3D(particles);
			
			//--------------------------------------------------------------------------
			//  timer
			//--------------------------------------------------------------------------
			timer = new Timer(15000); //Timerクラス、引数は繰返（　間隔、回数）
			timer.addEventListener(TimerEvent.TIMER, onTimer);//繰り返す処理,下記関数を呼び出している
			timer.start();
			
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		
		
		private function onTimer(e:TimerEvent):void 
		{
			onClickHandler();　//下記関数参照
		}
		
		private function onClickHandler():void 
		{
			//前の回転（一つ前のviewport)がどこまで残るかを指定している箇所？
			var num:int = basicBiew.viewport.containerSprite.childLayers.length - 1;
			Tweener.addTween(basicBiew.viewport.containerSprite.childLayers[num],{
				alpha:0,　//透明度を０にしているので消えるということ 
				time:10,　//前の回転が消えるまでの時間
				onComplete:removeLayer　//Ｔweenが終わった際にremoveLayer関数に移動
			});
			
			bel = new BitmapEffectLayer(basicBiew.viewport, stage.stageWidth, stage.stageHeight, true, 0x00000000, BitmapClearMode.CLEAR_PRE, false, false);
			bel.drawCommand.blendMode = BlendMode.ADD;
			bel.drawCommand.colorTransform = new ColorTransform(Math.random()*0.6+.2, Math.random()*0.6+.3, Math.random()*0.5+.4, .1);
			basicBiew.viewport.containerSprite.addLayer(bel);
			bel.addDisplayObject3D(particles);
			
			_world.rotationX = Math.random() * 360;
			_world.rotationY = Math.random() * 360;
			_world.rotationZ = Math.random() * 360;
			
		}
		
		private function removeLayer():void
		{
			basicBiew.viewport.containerSprite.removeLayerAt(0);
			bel.addDisplayObject3D(particles);
		}
		
		
		private function onLoop(e:Event):void 
		{
			_world.yaw(0.1); //Ｙ軸(yaw)に沿って回転,引数ではスピードを指定しているの？
		} 
		
	}

}