/**
 * Copyright albatrus_jp ( http://wonderfl.net/user/albatrus_jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9M7t
 */

package {
 　　　import flash.display.*;
   　　import flash.events.*;
  　　　import idv.cjcat.stardust.common.actions.*;
	  import idv.cjcat.stardust.common.clocks.*;
	  import idv.cjcat.stardust.common.emitters.*;
	  import idv.cjcat.stardust.common.renderers.*;
	  import idv.cjcat.stardust.common.initializers.*;
	  import idv.cjcat.stardust.common.math.*;
	  import idv.cjcat.stardust.twoD.actions.*;
	  import idv.cjcat.stardust.twoD.emitters.*;
	  import idv.cjcat.stardust.twoD.initializers.*;
	  import idv.cjcat.stardust.twoD.zones.*;
	  import idv.cjcat.stardust.twoD.renderers.*;
	 
	  public class Main extends Sprite {
	    private var emitter:Emitter2D; // エミッター
	    private var renderer:Renderer; // レンダラー
	 
	    // コンストラクタ
	    public function Main() {
	 
	      // パーティクルを格納するムービークリップを作成
	      var mc:MovieClip = new MovieClip();
	      mc.x = mc.y = 250; 
	      addChild(mc);
	 
	      //-- パーティクルシステムの構築
	      // [1]clockを作成
	      // 1ステップに発生させたい数値を指定
	      var clock: SteadyClock = new SteadyClock(1);
	      // [2]エミッターを作成
	      emitter = new Emitter2D(clock);
	      // [3]レンダラーを作成 (MCを指定)
	      renderer = new DisplayObjectRenderer(mc);
	      // [4]レンダラーにエミッターを追加
	      renderer.addEmitter(emitter);
	 
	      // [5]イニシャライザーを登録
	      // パーティクルのアイテムを指定
	      emitter.addInitializer(new DisplayObjectClass(MyCircle));
	      // パーティクルにかかる力を指定
	      emitter.addInitializer(new Velocity(new LazySectorZone(1, 0)));
	      // パーティクルのライフ(生存)を指定
	      emitter.addInitializer(new Life(new UniformRandom(50, 0)));
	 
	      // [6]アクションを登録
	      emitter.addAction(new Age()); // 寿命を有効化
          emitter.addAction(new DeathLife()); // 消えるを有効化
	      emitter.addAction(new Accelerate(0.2)); // 加速を有効化
	      emitter.addAction(new Move()); // 移動を有効化
	 
	      // エンターフレームイベントの登録
	      addEventListener(Event.ENTER_FRAME, loop);
	    }
	 
	    // エンターフレームイベント
	    private function loop(e:Event):void {
	      emitter.step(); // [7] エミッター更新
	    }
	  }
	}
	 
	// 円 (プライベートクラス)
	import flash.display.*;
	class MyCircle extends Sprite {
	  public function MyCircle() {
	    graphics.beginFill( Math.random()* 0xffffff); //赤色
	    graphics.drawCircle(0, 0, 10); // 円を描く
	  }
	}