/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Lv5
 */

// forked from enecre's 関数を中断したい
/*
    ゲームのAIを作りたいのですが、制限時間があるとします。
    選択時間内に_thinkが終わらなかった場合
    とりあえずその時点でのselectionが参照されるようになっていますが、
    もう考え続けないでいいのに考え続けてしまいます。
    40行目の位置から_think関数を止めたいのですが、可能でしょうか？
    
    メソッド _thinkの中で、残り時間をチェックするのはだめなの？
    関数を外部から止めることは不可能ですよ。
    関数内部で残り時間をチェックするのがシンプルで簡単だと思います。
    あとは、他の方がおっしゃってるように、疑似スレッドを使うとか
*/

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var tf:TextField = new TextField();
            addChild(tf);

            var moja:Ai = new Ai();
            moja.addEventListener("complete",function():void{
              tf.text = String(moja.selection);  
            });
            moja.think();
        }
    }
}
import flash.events.EventDispatcher;
import flash.events.Event;
import flash.utils.getTimer;

class Ai extends EventDispatcher{
    private var _selection:int;
    private var _limit:int = 1000;//1000ミリ秒をリミットにする
    public function get selection():int{return _selection;}
    function Ai(){}
    public function think():void{
        _think();
    }
    private function _think():void{
        /*
            ここで考える、時間がかかるかもしれない
        */
        var t:int = getTimer();
        var dt:int = 0;
        _selection = 3; //_selection 初期値
        while(true){
            _selection = _thinkCore();
            
            //経過時間をチェック
            dt = getTimer() - t;
            if(dt > _limit){
                break;
            }
        }
        dispatchEvent(new Event("complete"));
    }
    private function _thinkCore():int{
        // think処理を小さな単位する分割
        var ret:int = _selection + 1;
        return ret;
    }
}
