/**
 * Copyright Nowloading_ ( http://wonderfl.net/user/Nowloading_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9LT2
 */

// forked from ton_'s 跳ね返りとドラッグドロップの練習
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Throwing extends Sprite{
        private var ball:Ball;
        private var vx:Number;
        private var vy:Number;
        
        private var ball2:Ball;
        private var vx2:Number;
        private var vy2:Number;
        private var easing:Number = 0.05;
        
        private var bounce:Number = -0.7;
        private var gravity:Number = .5;
        private var oldx:Number;
        private var oldy:Number;
           
        public function Throwing(){
            init();
        }
        private function init():void{
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT
            ball = new Ball();
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;
            vx = Math.random()*10-5;
            vy = -10;
            addChild(ball);
            
            ball2 = new Ball(40,0x00ff00);
            ball2.x = Math.random()*stage.stageWidth;
            ball2.y = Math.random()*stage.stageHeight;
            addChild(ball2);
            
            addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        private function onEnterFrame(e:Event):void{
            vy += gravity;
            ball.x += vx;
            ball.y += vy;
            
            ball2Move();
            
            var left:Number = 0;
            var right:Number = stage.stageWidth;
            var top:Number = 0;
            var bottom:Number = stage.stageHeight;
            if(ball.x+ball.radius>right){
                ball.x = right-ball.radius;
                vx *= bounce;
            }else if(ball.x - ball.radius<left){
                ball.x = left + ball.radius;    
                vx *= bounce;
            }
            if(ball.y + ball.radius>bottom){
                ball.y = bottom-ball.radius;
                vy *= bounce;
                if ((Math.abs(vy) <= 0.5)&&(Math.abs(vx) <= 0.1)){
                    vx =0;
                }else if(Math.abs(vy) <= 0.5){
                    vx*=0.98;
                }

            }else if(ball.y - ball.radius<top){
                ball.y = top + ball.radius;
                vy *= bounce;
            }
            


        }
        private function onMouseDown(e:MouseEvent):void{
            oldx = ball.x;
            oldy = ball.y;
            stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            ball.startDrag();
            removeEventListener(Event.ENTER_FRAME,onEnterFrame);
            addEventListener(Event.ENTER_FRAME,trackVelocity);
        }
        private function onMouseUp(e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            ball.stopDrag();
            removeEventListener(Event.ENTER_FRAME,trackVelocity);
            addEventListener(Event.ENTER_FRAME,onEnterFrame);            
        }
        private function trackVelocity(e:Event):void{
            vx = ball.x - oldx;
            vy = ball.y - oldy;
            oldx = ball.x;
            oldy = ball.y;
            
            ball2Move();           
        }
        private function ball2Move():void{
            vx2 = (ball.x-ball2.x)*easing;
            vy2 = (ball.y-ball2.y)*easing;
            ball2.x+=vx2;
            ball2.y+=vy2;
        }  
    }
}


    import flash.display.*;
    import flash.geom.*;
    class Ball extends Sprite{
        public var radius:Number;
        public var color:uint;
        public var vx:Number =0;
        public var vy:Number =0;
        
        public function Ball(radius:Number = 40,color:uint = 0xff0000){
            this.radius = radius;
            this.color = color;
            init();
        }
        public function init():void{
            var matrix:Matrix = new Matrix();
      matrix.createGradientBox( 50, 50, 0, x-20, y);

            graphics.beginGradientFill( 
        GradientType.LINEAR, 
        [color, 0x0000ff], 
        [1, 1], 
        [0, 255], 
        matrix);

            graphics.drawCircle(0,0,radius);
            graphics.endFill();
        }
    }
            

