/**
 * Copyright jamasian ( http://wonderfl.net/user/jamasian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9LEc
 */

package {
    import flash.ui.Mouse;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class oneLife extends Sprite {
        public var bmd:BitmapData;
        public var bm:Bitmap;
        
        public var debug:TextField;
        
        public var color:Array    =    new Array();
        
        public var player:entity;
        public var center:Point;
        public var life:Array     =    new Array();
        
        public function oneLife() { init(); }
        
        public function init():void
        {
            /* initialize colors */
            color['bg']       =    0x0044FF;
            color['player']   =    0xFFFFFF;
            color['chain']    =    0xFFFFFF;
            color['virus']    =    0xFFFFFF;
            color['life']     =    0x007700;
            color['virus']    =    0x770077;
            color['enemy']    =    0xFF0000;
            
            //Mouse.hide();
            
            /* create display */
            bmd    =    new BitmapData(465, 465, false, color['bg']);
            bm     =    new Bitmap(bmd, "auto", true);
            addChild(bm);
            
            center    =    new Point(stage.width/2, stage.height/2);
            debug     =    mainframe();
            
            player             =    new entity(8, color['player'], 5, 2);
            player.drawPlayer();
            addChild(player);
            
            player.x           =    center.x;
            player.y           =    center.y;
            
           life[0]            =    player;
           life[0].addEventListener(Event.ENTER_FRAME, function(evt:Event):void { var e:*=evt.target; moveToDirection(e, mouseX, mouseY); });
           
           
           for (var i:int=1; i<=10; i++)
            {
                life[i]    =    new entity(5-i, color['chain'], 20, 12-i);
                life[i].drawChain();
                addChild(life[i]);
                
                life[i].x      = life[i-1].x+(i*2);
                life[i].y      = life[i-1].y+(i*2);
                
                life[i].addEventListener(Event.ENTER_FRAME, function(evt:Event):void
                {
                    var e:*        =    evt.target;
                    var i:int      =    life.indexOf(e);
                    
                    moveToDirection(life[i], life[i-1].x, life[i-1].y);
                });
            }
            
             stage.addEventListener(Event.ENTER_FRAME, onRun);
        }
        
        public function onRun(e:Event):void
        {
            debug.text    =    "px: " + player.x + "| py: " + player.y
                              +"\nmx: "+mouseX   + "| my: " + mouseY;

            bmd.fillRect(new Rectangle(0,0,stage.width, stage.height), color['bg']);
        }
        
        public function moveToDirection(e:entity, x:int, y:int, block:Boolean=false):void
        {
            var dir:Number    =    Math.atan2(y-e.y, x-e.x)*180/Math.PI;

            var perc:Number;
            var getX:Number;
            var getY:Number;
            var disX:Number;
            var disY:Number;
            
            disX=(x-e.x<0)? Math.sqrt((x-e.x)*-1) : Math.sqrt(x-e.x);
            disY=(y-e.y<0)? Math.sqrt((y-e.y)*-1) : Math.sqrt(y-e.y);
            
            perc=Math.pow(disX+disY, 2) / 400;
            perc=(perc>1.2)? 1.2 : perc;
            
            getX = (Math.cos(dir*Math.PI/180) * (perc*e.speed));
            getY = (Math.sin(dir*Math.PI/180) * (perc*e.speed));
            
            var newx:Number    =    e.x + getX;
            var newy:Number    =    e.y + getY;
            
            var collision:*   =    collision();
            
//            if (e.x >= x+(e.margin/2) || e.x <= x-(e.margin/2)){
//            if (e.y >= y+(e.margin/2) || e.y <= y-(e.margin/2)){
                e.rotation = 135 + dir;
                e.x=newx;
                e.y=newy;
//            }}
       }
       
       private function collision():*
       {
           /*
           search collision in every created entity.
           to create this effect: create a subclass that connects the main class + the entity class.
           u can create multiple entities, but you can only create ONE subclass.
           this subclass contains every entity ever created.
           
           using hittestObject u can see whether a certain object has touched something.
           it results FALSE if it hasnt touched anything;
           it results an object if it has touched the resulting object
           */
           return false;
       }

       
        private function mainframe():TextField
        {
            /*
            creates a textfield for debugging (mainframe).
            */
            var mainframe:TextField   =    new TextField();
            mainframe.width           =    stage.stageWidth;
            mainframe.height          =    100;
            mainframe.x               =    0;
            mainframe.y               =    0;
            mainframe.textColor       =    0xFFFFFF;
           
            mainframe.mouseEnabled    =    false;
            addChild(mainframe);
            
            return mainframe;
        }       
    }
}

import flash.display.Shape;
class entity extends Shape
{
    public var color:uint  =    0xFFFFFF;
    
    public var size:int    =    1;
    public var speed:int   =    0;
    public var margin:int  =    0;
    
    
    public function entity(_size:int=0, _color:uint=0, _speed:int=0, _margin:int=0):void
    {
        this.size     =    (_size!=0)?   _size   : this.size;
        this.color    =    (_color!=0)?  _color  : this.color;
        this.speed    =    (_speed!=0)?  _speed  : this.speed;
        this.margin   =    (_margin!=0)? _margin : this.margin;
    }
    
    public function drawPlayer():void
    {
        this.graphics.lineStyle(2, color);
        
        this.graphics.lineTo(size, 0);
        this.graphics.moveTo(0, 0);
        this.graphics.lineTo(0,size);
        
        this.graphics.moveTo(size+(size/4), 0);
        this.graphics.lineTo(size+(size/4)+(size/2), 0);
        
        this.graphics.moveTo(0, size+(size/4));
        this.graphics.lineTo(0, size+(size/4)+(size/2));
    }
    
    public function drawChain():void
    {
        this.graphics.lineStyle(2, color);
        this.graphics.beginFill(0xFFFFFF*(10/size), 1);
        this.graphics.drawCircle(this.x, this.y, size);
        this.graphics.endFill();
    }

}





