/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9KwE
 */

// forked from mex's 【AS100本ノック】4回目：オータム（秋）
/* 
 * AS100本ノック
 * 4回目のお題は「オータム（秋）」
 * あなたなりの「オータム（秋）」を表現してください。
 */
// 
// ルール
// 
// 1辺5の三角形に団子を積み上げていって、一番上に団子を置いた方の勝ち。
// 1ターンに何個でも置けるけど、(グレーのところに置けるよ)
// 同じ色の2個の団子の上にさらに同じ色の団子は置けないよ。
// 置き終わったらOKを押してね
// 
package {
    import flash.display.*;
    import flash.text.TextField;
    import flash.filters.*;
    import flash.events.*;
    import com.bit101.components.*;
    
    [SWF(backgroundColor="0x000000", frameRate="30")]
    public class DangoPyramid extends Sprite {
        private const N : int = 5;
        
        private var _tf : TextField;
        private var _d : Array;
        private var _canput : Sprite;
        
        private var rDango : Number = 25;
        private var bxDango : Number = 465 / 2;
        private var byDango : Number = 465 / 2;
        
        private var _submit : PushButton;
        private var _retry : PushButton;
        
        public function DangoPyramid() {
            Wonderfl.capture_delay(1);
            
            _tf = new TextField();
            addChild(_tf);
            _tf.textColor = 0xffffff;
            _tf.height = 450;
            
            _canput = new Sprite();
            _canput.x = bxDango; _canput.y = byDango;
            addChild(_canput);
            
            _submit = new PushButton(this, 385, 400, "OK", onSubmitClick);
            _submit.width = 50;
            
            _retry = new PushButton(this, 30, 400, "RETRY", onRetryClick);
            _retry.width = 50;
            
            var g : Graphics = graphics;
            for(var i : int = 0;i < 200;i++){
                var color : uint = 
                    (255 - (Math.random() * 60)) << 16 |
                    (255 - (Math.random() * 60)) << 8 |
                    (255 - (Math.random() * 60)) << 0;
                g.beginFill(color);
                g.drawCircle(Math.random() * 465, Math.random() * 465, Math.random() * 2);
                g.endFill();
            }
            g.lineStyle(1, 0x997f3f);
            g.beginFill(0x997f3f);
            g.drawRect(bxDango - 150, byDango + 198, 300, 35);
            g.endFill();
            
            _shapes = [];
            
            init();
        }
 
        private function init() : void
        {
            for each(var s : Shape in _shapes){
                removeChild(s);
            }
            _shapes = [];
            
            _d = new Array(N * N);
            var i : int, j : int;
            for(i = 0;i < N;i++){
                for(j = 0;j <= i;j++){
                    _d[i * N + j] = 0;
                }
            }
            
            drawCanPut();
            nPut = 0;
            
            _canput.mouseEnabled = true;
            _canput.addEventListener(MouseEvent.CLICK, onCanPutClick);
        }
        
        private var _shapes : Array;
        
        private function onRetryClick(e : MouseEvent) : void
        {
            init();
        }
        
        private function onSubmitClick(e : MouseEvent) : void
        {
            if(nPut == 0 && _cps.length > 0)return;
            
            var a : Array = algo(-1);
            if(a != null){
                for each(var s : Array in a){
                    putDango(s[0], s[1], -1);
                    if(s[0] == 0 && s[1] == 0)doYouLose();
                }
                drawCanPut();
            }else{
                do{
                    var cps : Array = canPut(-1);
                    if(cps.length > 0){
                        var cp : Array = cps[int(Math.random() * cps.length)];
                        putDango(cp[0], cp[1], -1);
                    }else{
                        break;
                    }
                }while(canPut(1).length == 0);
            }
            drawCanPut();
            nPut = 0;
        }
        
        // だんごを置く
        private function putDango(r : int, c : int, turn : int) : void
        {
            _d[r * N + c] = turn;
            
            var dw : Shape = turn == 1 ? makeDangoW() : makeDangoG();
            dw.x = -rDango * r + rDango * 2 * c + bxDango;
            dw.y = Math.sqrt(3) * rDango * r + byDango;
            
            _shapes.push(dw);
            addChild(dw);
        }
        
        private function onCanPutClick(e : MouseEvent) : void
        {
            var r : int = e.localY / (Math.sqrt(3) * rDango) + 0.5;
            var c : int = e.localX / (2 * rDango) + r * 0.5 + 0.5;
            putDango(r, c, 1);
            nPut++;
            
            if(r == 0 && c == 0)doYouWin();
            
            drawCanPut();
        }
        
        private var _cps : Array = [];
        private var nPut : int;
        
        // 白が置ける場所を表示
        private function drawCanPut() : void
        {
            var g : Graphics = _canput.graphics;
            g.clear();
            g.lineStyle(1, 0xffffff);
            g.beginFill(0x333333);
            
            _cps = canPut(1);
            for each(var cp : Array in _cps){
                g.drawCircle(-rDango * cp[0] + rDango * 2 * cp[1], Math.sqrt(3) * rDango * cp[0], rDango - 1);
            }
            g.endFill();
        }
        
        private function canPut(turn : int) : Array
        {
            var i : int, j : int;
            var ret : Array = [];
            for(i = 0;i < N;i++){
                for(j = 0;j <= i;j++){
                    if(_d[i * N + j] != 0)continue;
                    if(i == N - 1 || (_d[(i + 1) * N + j] != 0 && _d[(i + 1) * N + j + 1] != 0)){
                        if(i < N - 1 && _d[(i + 1) * N + j] == turn && _d[(i + 1) * N + j + 1] == turn){
                            continue;
                        }
                        ret.push([i, j]);
                    }
                }
            }
            return ret;
        }
        
        private function algo(turn : int) : Array
        {
            if(_d[0] != 0)return null;
            var i : int, j : int;
            
            // put
            var put : Boolean = false;
            for(i = 0;i < N;i++){
                for(j = 0;j <= i;j++){
                    if(_d[i * N + j] != 0)continue;
                    if(i == N - 1 || (_d[(i + 1) * N + j] != 0 && _d[(i + 1) * N + j + 1] != 0)){
                        if(i < N - 1 && _d[(i + 1) * N + j] == turn && _d[(i + 1) * N + j + 1] == turn){
                            continue;
                        }
                        put = true;
                        _d[i * N + j] = turn;
                        if(algo(-turn) == null){
                            _d[i * N + j] = 0;
                            return [[i, j]];
                        }
                        
                        var v : Array = algo(turn);
                        if(v != null){
                            _d[i * N + j] = 0;
                            v.unshift([i, j]);
                            return v;
                        }
                        
                        _d[i * N + j] = 0;
                    }
                }
            }
            if(!put){
                var a : Array = algo(-turn);
                if(a == null){
                    return [];
                }else{
                    return null;
                }
            }
            return null;
        }
        
        private function makeDangoW() : Shape
        {
            var ret : Shape = new Shape();
            var g : Graphics = ret.graphics;
            ret.filters = [new DropShadowFilter(10, 45, 0xffffff, 1, 8, 8, 1, 1, true, false)];
            g.beginFill(0xe3e3e3);
            g.drawCircle(0, 0, rDango);
            g.endFill();
            
            return ret;
        }
        
        private function makeDangoG() : Shape
        {
            var ret : Shape = new Shape();
            var g : Graphics = ret.graphics;
            ret.filters = [new DropShadowFilter(10, 45, 0xbbffbb, 1, 8, 8, 1, 1, true)];
            g.beginFill(0x66dd66);
            g.drawCircle(0, 0, rDango);
            g.endFill();
            
            return ret;
        }
        
        private function doYouLose() : void
        {
            var moon : Shape = makeHalfMoon();
            moon.x = 465 / 2;
            moon.y = 100;
            addChild(moon);
            _shapes.push(moon);
        }
        
        private function doYouWin() : void
        {
            var moon : Shape = makeFullMoon();
            moon.x = 465 / 2;
            moon.y = 100;
            addChild(moon);
            _shapes.push(moon);
        }
        
        private function makeHalfMoon() : Shape
        {
            var ret : Shape = new Shape();
            var g : Graphics = ret.graphics;
            ret.filters = [new DropShadowFilter(10, 45, 0xffff00, 1, 8, 8, 1, 1, true, true), new GlowFilter(0xcccc00, 1, 64, 64, 7, 3)];
            g.beginFill(0xdddd00);
            g.drawCircle(0, 0, 20);
            g.endFill();
            
            return ret;
        }
        
        private function makeFullMoon() : Shape
        {
            var ret : Shape = new Shape();
            var g : Graphics = ret.graphics;
            ret.filters = [new DropShadowFilter(10, 45, 0xffff00, 1, 8, 8, 1, 1, true), new GlowFilter(0xcccc00, 1, 64, 64, 6, 3)];
            g.beginFill(0xdddd00);
            g.drawCircle(0, 0, 20);
            g.endFill();
            
            return ret;
        }
    }
}