/**
 * Copyright romatica ( http://wonderfl.net/user/romatica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9KDx
 */

/**
 * Alternative3DでCOLLADA読み込みテスト
 * モデルはBlenderで作成
 * 
 * なんか気持ち横長に表示されている気がする　
 * PaperVision3D版はこちら　http://wonderfl.net/c/kIrA
 *-------------------------------------------------------
 * @author itoz ( http://www.romatica.com )
 */
 
package
{
    import alternativ7.engine3d.containers.BSPContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.loaders.ParserCollada;


    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    /**
     * 
     */
    public class ColladaLoadTest extends Sprite
    {
        private static const COLLADA_URL : String = "http://www.romatica.com/work/amazon-san/AmazonCollada.dae";
        private var _parser : ParserCollada;
        private var _loader : URLLoader;
        private var _mloader : MaterialLoader;
        private var _camera : Camera3D;
        private var _controller : SimpleObjectController;
        private var _scene : BSPContainer;
        private var _amazon : Object3D;


        public function ColladaLoadTest()
        {
            addEventListener( Event.ADDED_TO_STAGE, _init );
        }

        private function _init(event : Event) : void
        {
            removeEventListener( Event.ADDED_TO_STAGE, _init );
            _controller = new SimpleObjectController( stage, _camera, 1 );
            _scene = new BSPContainer();
            _camera = _scene.addChild( new Camera3D() ) as Camera3D;
            _camera.view = addChild( new View( stage.stageWidth, stage.stageHeight ) ) as View;
            loadCollada();
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　Collada読み込みスタート
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        private function loadCollada() : void
        {
            _loader = new URLLoader();
            _loader.addEventListener( Event.COMPLETE, onLoadCollada );
            _loader.load( new URLRequest( COLLADA_URL ) );
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　Collada読み込み完了
        //
        private function onLoadCollada(e : Event) : void
        {
            // パース
            _parser = new ParserCollada();
            _parser.parse( new XML( _loader.data ), COLLADA_URL );

            // colladaテクスチャロード
            _mloader = new MaterialLoader();
            _mloader.addEventListener( Event.COMPLETE, onCompleteMaterial );
            _mloader.load( _parser.textureMaterials, new LoaderContext( true ) );
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　 テクスチャ読み込み完了
        private function onCompleteMaterial(e : Event) : void
        {
            _amazon = _scene.addChild( _parser.getObjectByName( "Cube" ) ) as Object3D;
            //名前がわからない場合　for each(var o3d:Object3D in _parser.objects) {trace(o3d.name);}
            _amazon.rotationX = 90 * (Math.PI / 180);// ラジアン
            _amazon.scaleX = _amazon.scaleY = _amazon.scaleZ = 0.5;
            addEventListener( Event.ENTER_FRAME, onTick );
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　   　　　　　　　 update
        private function onTick(e : Event) : void
        {
            _amazon.rotationY += 0.05;
            _camera.render();
        }
    }
}