/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9JeW
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.*;
    import flash.geom.*;
    
    public class Professional extends Sprite {
        
        private var pattern:BitmapData;
        private var offsets:Array = [ new Point(Math.random()*10,Math.random()*10), 
                                      new Point(Math.random()*10,Math.random()*10) ];
        private var speeds:Array = [ new Point(0.5,0), new Point( 0,0.5) ];
        private var size:int = 32;
        private var perlinMap:BitmapData;
        
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            perlinMap = new BitmapData(size,size,false,0);
            
            //generate bitmap pattern.
            pattern = makePattern();
           
            var g:Graphics = graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,480,480);
            g.endFill();
            
            stage.addEventListener( Event.ENTER_FRAME, animatePattern);
            
         }
        
        //Obviously this is not the cleanest way of doign this,
        //but I wanted to stay true to the rule: "use the BitmapPatternBuilder Class"
        
        public function animatePattern( event:Event ):void{
          var ptrn:BitmapData =  makePattern()
          pattern.copyPixels(ptrn, pattern.rect, pattern.rect.topLeft );
          ptrn.dispose();
        }
        
        public function makePattern():BitmapData{
            perlinMap.perlinNoise(size*0.5,size*0.5,2,0xBADA55,false,false,4,false,offsets );
            offsets[0] = Point(offsets[0]).add(Point(speeds[0]));
            offsets[1] = Point(offsets[1]).add(Point(speeds[1]));
            var px:int;
            var pixels:Array = [];
            for ( var y:int = 0; y < size; y++ )
            {
                var line:Array = [];
                for ( var x:int = 0; x < size; x++ )
                {
                    
                    line.push( px = int( (perlinMap.getPixel(x,y) & 0xff) / (255 / 3 )));
                    line.unshift( px );
                } 
                pixels.push( line );
                pixels.unshift( line );
            }
            
            
            return BitmapPatternBuilder.build(
                pixels,
                [0xff000000, 0xffff8000,0xffffffff]
            );
        }
    
       
    
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}