/**
 * Copyright syROBO ( http://wonderfl.net/user/syROBO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9H9m
 */

// forked from shuff's ColorfulStar
//	クリックしたら星が出る何か

package {
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.GlowFilter;	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	[SWF(backgroundColor=0x0,height=512,width=512)]
	
	
	public class Main extends Sprite
	{
		private var circle:Sprite;
		private var stars:Array=[];	
		
		public function Main(){
		stage.addEventListener(MouseEvent.CLICK,setCircle);
		}
	
	
	//丸を作る
	private function makeCircle():Sprite{
		var cc:Sprite = new Sprite();
		cc.graphics.beginFill(Math.random()*0xffffff);
		//ここの環境での値
		cc.graphics.drawCircle(0,0,50);
		/*
		//FlexBuilderの環境での値
		cc.graphics.drawCircle(0,0,10);
		*/
		cc.graphics.endFill();
		return cc;
	}
	
	//クリックされたときに丸を表示する
	private function setCircle(e:MouseEvent):void{
		circle = makeCircle();
		
		for(var angle:int = 0 ; angle < 360 ; angle += 30){
			var star:Star = new Star(Math.random()*0xffffff,15,5,mouseX,mouseY,Math.cos(angle*Math.PI/180)*5,Math.sin(angle*Math.PI/180)*5);
			star.filters = [new GlowFilter(0xffffff,1,7,7,2)];
			star.blendMode = BlendMode.ADD;
			stars.push(star);
			
			addChild(star);
		}
		
		circle.filters = [new GlowFilter(0xffffff,2,30,30,3)];
		circle.blendMode = BlendMode.ADD;
		addChild(circle);
		addEventListener(Event.ENTER_FRAME,onEnterframe);
	
		//丸を拡大させた後に縮小させる動作
		var exp:ITween = BetweenAS3.tween(circle,{scaleX:20,scaleY:20},null,0.3);
		exp.play();
		var shr:ITween = BetweenAS3.tween(circle,{scaleX:0,scaleY:0},null,0.3);
		shr.play();
		/*
		var exp:ITween = BetweenAS3.tween(circle,{scaleX:8,scaleY:8},{scaleX:1,scaleY:1},0.25);
		exp.play();
		var shr:ITween = BetweenAS3.tween(circle,{scaleX:0,scaleY:0},{scaleX:1,scaleY:1},3);
		shr.play();
		*/

		circle.x = mouseX;
		circle.y = mouseY;
	}


	//星をフレーム毎に動かし、ステージ上にあるかをチェックする	
	private function onEnterframe(e:Event):void{
		for(var i:int = 0;i<stars.length;i++){
		stars[i].move();
		
		if(stars[i].x<-50||stage.stageWidth+50<stars[i].x||
			stars[i].y<-50||stage.stageHeight+50<stars[i].y){
				removeChild(stars[i]);
				stars.splice(i--,1);
			}
		}
	}
	}
}



//星を作っていくクラス
import flash.display.Sprite;	
class Star extends Sprite
{
	public var vx:Number;
	public var vy:Number;
		
	public function Star(color:uint,r:Number,p:int,x:Number,y:Number,vx:Number,vy:Number)
	{
		var r2:Number=r/2;
		var angle:Number=0;
		var addition:Number=360/(p*2);
		
		graphics.beginFill(color);	
		graphics.moveTo(r,0);
		
		for(var i:uint=0;i<p*2;i++){
			angle += addition;
			var to_x:Number;
			var to_y:Number;
			var radian:Number=angle*Math.PI/180;
	
			if(i%2){
				to_x=r*Math.cos(radian);
				to_y=r*Math.sin(radian);
			}else{
				to_x=r2*Math.cos(radian);
				to_y=r2*Math.sin(radian);
			}
			graphics.lineTo(to_x,to_y);
		}
		graphics.endFill();
		
		this.x = x;
		this.y = y;
		this.vx = vx;
		this.vy = vy;
	}
	
	//星を動かしていく
	public function move():void{
		
		//下に落ちていくおまけ動作
		//vy+=0.8;
		
		this.x+=vx;
		this.y+=vy;
		this.rotationY+=50;
	}
}