/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Gwn
 */

// forked from yawakisin's Papervision3d入門 2.3.3
/*
	Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト	
	
	code 2.3.3
*/

package 
{
	import org.papervision3d.materials.*;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.primitives.*;
	
	public class PaperPlaneSample extends BasicView {
		
		// コンストラクタ
		public function PaperPlaneSample() {
			
			// マテリアルを作成
			var material:WireframeMaterial = new WireframeMaterial(0x3399ff);
			material.doubleSided = true;
			
			// 飛行機を作成
			var pp:PaperPlane = new PaperPlane(material, 3);
		
			// シーンに追加
			scene.addChild(pp);
		
			// 飛行機の位置座標
			pp.x = 100;
			pp.y = 200;
			pp.z = 300;
			// 飛行機の角度
			pp.rotationX = -40;
			pp.rotationY = -25;
			// 飛行機のスケールを設定
			pp.scaleX = 1.5;
			pp.scaleY = 1.5;
			pp.scaleZ = 2.0;
			
			// レンダリング
			startRendering();
		}
	}
}
