/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9GlQ
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.text.TextField;

	[SWF(width = "500", height = "500", backgroundColor = "0x000000", fps = "60")] 
	public class Practice37 extends Sprite {
		private var par:Array;
		private var bitmap:BitmapData;
		private var blur:BlurFilter;
		private var colors:Array = [0xffffffff,0xffffcdff,0xffbebebe,0xffc7c7c7,0xffaaaaaa];
		private var box:Box;
		private var rad:Number = 0;
		private var wall:Wall;
		private var isPick:Boolean = false;
		private var bt:MovieClip;
		
		public function Practice37() {
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			var img:Bitmap = new Bitmap(bitmap);
			addChild(img);
			blur = new BlurFilter(4, 4, 3);
			box = new Box(bitmap);
			Particle.bitmap = bitmap;
			par = new Array();
			for (var i:int = 0; i < 10000; i++) {
				var p:Particle = new Particle(210+Math.random() * 90, Math.random() * 120+50, colors[i % colors.length]);
				par.push(p);
			}
			addEventListener(Event.ENTER_FRAME, update);
			wall = new Wall(bitmap);
			box.wall = wall;
			addChild(wall);
			var mc:MovieClip = new MovieClip();
			mc.graphics.lineStyle(2, 0xff0000);
			mc.graphics.moveTo(480, 30);mc.graphics.lineTo(480, 470);
			addChild(mc);
			bt = new MovieClip();
			bt.graphics.beginFill(0xff3333);
			bt.graphics.drawRect(0, 0, 10, 10);
			bt.x = 475; bt.y = 30;
			mc.addChild(bt);
			stage.addEventListener(MouseEvent.MOUSE_UP, function mouseUp(e:MouseEvent):void { isPick = false; } );
			stage.addEventListener(MouseEvent.MOUSE_DOWN,function mouseDown(e:MouseEvent):void{isPick = true;});
		}
		
		private function update(e:Event):void {
			for each(var p:Particle in par) box.checkParticle(p);
			if (isPick) {
				bt.y = Math.max(30, Math.min(470, mouseY));
				var tmp:Number = ((bt.y - 30.0) / 440.0)*Math.PI*2;
				var deg:Number = tmp - rad;
				if (deg != 0)rotStage(deg);
				rad = tmp;
			}
			box.clear();
			bitmap.applyFilter(bitmap,bitmap.rect,new Point(0,0),blur);
			bitmap.lock();
			for each(p in par) {
				p.update();
				box.setParticle(p);
			}
			bitmap.unlock();
		}

		private function rotStage(a:Number):void {
			for each(var p:Particle in par) {
				var rx:Number = (p.x - bitmap.width / 2) * Math.cos(a) - (p.y - bitmap.height / 2) * Math.sin(a) + bitmap.width / 2;
				var ry:Number = (p.x - bitmap.width / 2) * Math.sin(a) + (p.y - bitmap.height / 2) * Math.cos(a) + bitmap.height / 2;
				p.x = rx; p.y = ry;
			}
			wall.rotWall(a);
			wall.drawWall();
		}
	}
}
import flash.display.BitmapData;
import flash.display.MovieClip;
import flash.geom.Point;

class Wall extends MovieClip {
	private var wall:Vector.<int>;
	private var line:Vector.<Point>;
	private var tmp:BitmapData;
	private var imageWidth:int;
	private var imageHeight:int;
	private var ww:int = 80;
	private var hh:int = 120;
	
	public function Wall(b:BitmapData):void {
		imageWidth = b.width;
		imageHeight = b.height;
		wall = new Vector.<int>();
		line = new Vector.<Point>();
		var id:int = 0;
		for (var x:int = 0; x < b.width; x++) for (var y:int = 0; y < b.height; y++) wall[id++] = 0;
		initLine();
		drawWall();
	}
	
	private function initLine():void {
		var xx:Number; var yy:Number;
		for (var ang:Number = 0; ang < 1.1 * Math.PI; ang += 0.01) {
			xx = ww * Math.cos(ang) + imageWidth / 2;	yy = hh * Math.sin(ang) + imageHeight / 2 + hh;
			line.push(new Point(xx, yy));
		}
		xx = ww * Math.cos(1.485*Math.PI) + imageWidth / 2;	yy = hh * Math.sin(1.485*Math.PI) + imageHeight / 2 + hh;
		line.push(new Point(xx, yy));
		for (; -0.1 * Math.PI < ang; ang -= 0.01) {
			xx = ww * Math.cos(ang)+imageWidth/2;	yy = -hh * Math.sin(ang)+imageHeight/2-hh;
			line.push(new Point(xx, yy));
		}
		xx = ww * Math.cos( -0.485 * Math.PI) + imageWidth / 2;	yy = hh * Math.sin( -0.485 * Math.PI) + imageHeight / 2 + hh;
		line.push(new Point(xx, yy));
		for (; 0 > ang; ang += 0.01) {
			xx = ww * Math.cos(ang) + imageWidth / 2;	yy = hh * Math.sin(ang) + imageHeight / 2 + hh;
			line.push(new Point(xx, yy));
		}
	}

	public function rotWall(a:Number):void {
		for each(var p:Point in line) {
			var xx:Number = rotX(p.x, p.y, a);
			var yy:Number = rotY(p.x, p.y, a);
			p.x = xx;	p.y = yy;
		}
	}
	
	private function rotX(xx:Number,yy:Number,rad:Number):Number {
		var rx:Number = (xx-imageWidth/2) * Math.cos(rad) - (yy-imageHeight/2) * Math.sin(rad)+imageWidth/2;
		return rx;
	}
	
	private function rotY(xx:Number,yy:Number,rad:Number):Number {
		var ry:Number = (xx-imageWidth/2) * Math.sin(rad) + (yy-imageHeight/2) * Math.cos(rad)+imageHeight/2;
		return ry;
	}
	
	public function drawWall():void {
		graphics.clear();
		graphics.lineStyle(2, 0x00ffff);
		for (var i:int = 0; i < line.length; i++) {
			if (i == 0) {
				graphics.moveTo(line[i].x, line[i].y);
			}else {
				graphics.lineTo(line[i].x, line[i].y);
			}
		}
		tmp = new BitmapData(imageWidth, imageHeight, false, 0x000000);
		createBounds();
	}
	
	public function createBounds():void {
		tmp.fillRect(tmp.rect, 0x000000);
		tmp.draw(this);
		var id:int = 0;
		for (var i:int = 0; i < tmp.width; i++) {
			for (var j:int = 0; j < tmp.height; j++) {
				if (tmp.getPixel(i, j) == 0) {
					wall[id++] = 0;
				}else {
					wall[id++] = 1;
				}
			}
		}
	}
	
	public function init(b:Vector.<int>):void {
		for (var i:int = 0; i < b.length; i++) b[i] = wall[i];
	}
}

class Box {
	public var wall:Wall;
	private var box:Vector.<int>;
	private var bitmap:BitmapData;
	private var width:int;
	private var height:int;
	
	public function Box(b:BitmapData) {
		bitmap = b;
		width = bitmap.width;
		height = b.height;
		box = new Vector.<int>();
		var id:int = 0;
		for (var x:int = 0; x < width; x++)	for (var y:int = 0; y < height; y++) box[id++] = 0;
	}

	public function clear():void {
		wall.init(box);
	}
	
	public function setParticle(p:Particle):void {
		box[getId(p.x,p.y)] = 1;
	}

	private function getId(x:int, y:int):int {
		return Math.min(Math.max(0, x * height + y), box.length - 1);
	}
	
	public function checkParticle(p:Particle):void {
		if (box[getId(p.x,p.y+1)] == 1) {
			if (box[getId(p.x - 1, p.y + 1)] == 1) {
				if (box[getId(p.x + 1, p.y + 1)] == 1) {
					p.movable = false;	p.vx = 0;	p.vy = 0;
				}else {
					if(p.x<width-1&&box[getId(p.x + 1, p.y)] == 0)p.vx += 1;
				}
			}else if (box[getId(p.x +1, p.y + 1)] == 1) {
				if(p.x>0&&box[getId(p.x -1, p.y)] == 0)p.vx -= 1;
			}else {
				if (p.x > 0 && box[getId(p.x -1, p.y)] == 0) {
					if (p.x < width - 1 && box[getId(p.x + 1, p.y)] == 0) {
						if (Math.random() <= 0.5) {p.vx += 1;}else {p.vx -= 1;}
					}else {
						p.vx += 1;
					}
				}else {
					if (p.x < width - 1 && box[getId(p.x + 1, p.y)] == 0) {
						p.vx -= 1;
					}else {
						p.movable = false;	p.vx = 0;	p.vy = 0;
					}
				}
			}
		}else {
			p.movable = true;
			p.vx = 0;
			for (var v:int = 1; v < p.vy; v++) {
				if (box[getId(p.x , p.y + v)] == 1) {
					p.vy = v - 1;
					break;
				}
			}
		}
	}
}

class Particle {
	public static var bitmap:BitmapData;
	public static const G:Number = 0.098*2;
	public const K:Number = 0.01;
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var color:uint;
	public var movable:Boolean = true;
	
	public function Particle(_x:int,_y:int,_c:uint):void {
		x = _x;	y = _y;	color = _c;
		vx = 0;	vy = 0;
	}
	
	public function update():void {
		x += vx;
		y += vy;
		bitmap.setPixel(x, y, color);
		if (movable) {
			var a:Number = G - vy * K;
			vy += a;
			if (vx > 0) {
				vx -= 1;
			}else if (vx < 0) {
				vx += 1;
			}
		}
		if (y > 500) y = 500;
	}
}